package io.vertx.mutiny.kafka.client.producer;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import java.util.List;

/**
 * Vert.x Kafka producer record.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.kafka.client.producer.KafkaProducerRecord original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.kafka.client.producer.KafkaProducerRecord.class)
public class KafkaProducerRecord<K,V> {

  public static final io.smallrye.mutiny.vertx.TypeArg<KafkaProducerRecord> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new KafkaProducerRecord((io.vertx.kafka.client.producer.KafkaProducerRecord) obj),
    KafkaProducerRecord::getDelegate
  );

  private final io.vertx.kafka.client.producer.KafkaProducerRecord<K,V> delegate;
  public final io.smallrye.mutiny.vertx.TypeArg<K> __typeArg_0;
  public final io.smallrye.mutiny.vertx.TypeArg<V> __typeArg_1;
  
  public KafkaProducerRecord(io.vertx.kafka.client.producer.KafkaProducerRecord delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();    this.__typeArg_1 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public KafkaProducerRecord(Object delegate, TypeArg<K> typeArg_0, TypeArg<V> typeArg_1) {
    this.delegate = (io.vertx.kafka.client.producer.KafkaProducerRecord)delegate;
    this.__typeArg_0 = typeArg_0;
    this.__typeArg_1 = typeArg_1;
  }

  public KafkaProducerRecord(io.vertx.kafka.client.producer.KafkaProducerRecord delegate, io.smallrye.mutiny.vertx.TypeArg<K> typeArg_0, io.smallrye.mutiny.vertx.TypeArg<V> typeArg_1) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
    this.__typeArg_1 = typeArg_1;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  KafkaProducerRecord() {
    this.delegate = null;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();    this.__typeArg_1 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public io.vertx.kafka.client.producer.KafkaProducerRecord getDelegate() {
    return delegate;
  }

  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.kafka.client.producer.KafkaHeader> TYPE_ARG_0 = new TypeArg<io.vertx.mutiny.kafka.client.producer.KafkaHeader>(o1 -> io.vertx.mutiny.kafka.client.producer.KafkaHeader.newInstance((io.vertx.kafka.client.producer.KafkaHeader)o1), o1 -> o1.getDelegate());
  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    KafkaProducerRecord that = (KafkaProducerRecord) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param topic the topic this record is being sent to
   * @param key the key (or null if no key is specified)
   * @param value the value
   * @param timestamp the timestamp of this record
   * @param partition the partition to which the record will be sent (or null if no partition was specified)
   * @return Vert.x producer record
   */
  public static <K, V> io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord<K, V> create(String topic, K key, V value, Long timestamp, Integer partition) { 
    io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord<K, V> ret = io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord.newInstance((io.vertx.kafka.client.producer.KafkaProducerRecord)io.vertx.kafka.client.producer.KafkaProducerRecord.create(topic, key, value, timestamp, partition), TypeArg.unknown(), TypeArg.unknown());
    return ret;
  }

  /**
   * @param topic the topic this record is being sent to
   * @param key the key (or null if no key is specified)
   * @param value the value
   * @return Vert.x producer record
   */
  public static <K, V> io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord<K, V> create(String topic, K key, V value) { 
    io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord<K, V> ret = io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord.newInstance((io.vertx.kafka.client.producer.KafkaProducerRecord)io.vertx.kafka.client.producer.KafkaProducerRecord.create(topic, key, value), TypeArg.unknown(), TypeArg.unknown());
    return ret;
  }

  /**
   * @param topic the topic this record is being sent to
   * @param value the value
   * @return Vert.x producer record
   */
  public static <K, V> io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord<K, V> create(String topic, V value) { 
    io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord<K, V> ret = io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord.newInstance((io.vertx.kafka.client.producer.KafkaProducerRecord)io.vertx.kafka.client.producer.KafkaProducerRecord.create(topic, value), TypeArg.unknown(), TypeArg.unknown());
    return ret;
  }

  /**
   * @return the topic this record is being sent to
   */
  public String topic() { 
    String ret = delegate.topic();
    return ret;
  }

  /**
   * @return the key (or null if no key is specified)
   */
  public K key() { 
    K ret = (K)__typeArg_0.wrap(delegate.key());
    return ret;
  }

  /**
   * @return the value
   */
  public V value() { 
    V ret = (V)__typeArg_1.wrap(delegate.value());
    return ret;
  }

  /**
   * @return the timestamp of this record
   */
  public Long timestamp() { 
    Long ret = delegate.timestamp();
    return ret;
  }

  /**
   * @return the partition to which the record will be sent (or null if no partition was specified)
   */
  public Integer partition() { 
    Integer ret = delegate.partition();
    return ret;
  }

  /**
   * @param key 
   * @param value 
   * @return the instance of KafkaProducerRecord<K,V> to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord<K, V> addHeader(String key, String value) { 
    delegate.addHeader(key, value);
    return this;
  }

  /**
   * @param key 
   * @param value 
   * @return the instance of KafkaProducerRecord<K,V> to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord<K, V> addHeader(String key, io.vertx.mutiny.core.buffer.Buffer value) { 
    delegate.addHeader(key, value.getDelegate());
    return this;
  }

  /**
   * @param header the header
   * @return current KafkaProducerRecord instance
   */
  @Fluent
  public io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord<K, V> addHeader(io.vertx.mutiny.kafka.client.producer.KafkaHeader header) { 
    delegate.addHeader(header.getDelegate());
    return this;
  }

  /**
   * @param headers the headers
   * @return current KafkaProducerRecord instance
   */
  @Fluent
  public io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord<K, V> addHeaders(List<io.vertx.mutiny.kafka.client.producer.KafkaHeader> headers) { 
    delegate.addHeaders(headers.stream().map(elt -> elt.getDelegate()).collect(java.util.stream.Collectors.toList()));
    return this;
  }

  /**
   * @return the headers of this record
   */
  public List<io.vertx.mutiny.kafka.client.producer.KafkaHeader> headers() { 
    if (cached_0 != null) {
      return cached_0;
    }
    List<io.vertx.mutiny.kafka.client.producer.KafkaHeader> ret = delegate.headers().stream().map(elt -> io.vertx.mutiny.kafka.client.producer.KafkaHeader.newInstance((io.vertx.kafka.client.producer.KafkaHeader)elt)).collect(java.util.stream.Collectors.toList());
    cached_0 = ret;
    return ret;
  }

  private List<io.vertx.mutiny.kafka.client.producer.KafkaHeader> cached_0;
  public static <K,V>KafkaProducerRecord<K,V> newInstance(io.vertx.kafka.client.producer.KafkaProducerRecord arg) {
    return arg != null ? new KafkaProducerRecord<K,V>(arg) : null;
  }


  public static <K,V>KafkaProducerRecord<K,V> newInstance(io.vertx.kafka.client.producer.KafkaProducerRecord arg, io.smallrye.mutiny.vertx.TypeArg<K> __typeArg_K, io.smallrye.mutiny.vertx.TypeArg<V> __typeArg_V) {
    return arg != null ? new KafkaProducerRecord<K,V>(arg, __typeArg_K, __typeArg_V) : null;
  }

}
