package io.vertx.mutiny.ext.auth.oauth2.providers;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.http.HttpClientOptions;

/**
 * Simplified factory to create an  for GitLab.com.
 *
 * <a href="https://gitlab.com/help/api/oauth2.md">https://gitlab.com/help/api/oauth2.md</a>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.oauth2.providers.GitLabAuth original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.auth.oauth2.providers.GitLabAuth.class)
public class GitLabAuth {

  public static final io.smallrye.mutiny.vertx.TypeArg<GitLabAuth> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new GitLabAuth((io.vertx.ext.auth.oauth2.providers.GitLabAuth) obj),
    GitLabAuth::getDelegate
  );

  private final io.vertx.ext.auth.oauth2.providers.GitLabAuth delegate;
  
  public GitLabAuth(io.vertx.ext.auth.oauth2.providers.GitLabAuth delegate) {
    this.delegate = delegate;
  }

  public GitLabAuth(Object delegate) {
    this.delegate = (io.vertx.ext.auth.oauth2.providers.GitLabAuth)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  GitLabAuth() {
    this.delegate = null;
  }

  public io.vertx.ext.auth.oauth2.providers.GitLabAuth getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GitLabAuth that = (GitLabAuth) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param vertx 
   * @param clientId the client id given to you by GitLab
   * @param clientSecret the client secret given to you by GitLab
   * @return 
   */
  public static io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth create(io.vertx.mutiny.core.Vertx vertx, String clientId, String clientSecret) { 
    io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth ret = io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)io.vertx.ext.auth.oauth2.providers.GitLabAuth.create(vertx.getDelegate(), clientId, clientSecret));
    return ret;
  }

  /**
   * @param vertx 
   * @param site root URL for the provider without trailing slashes, eg. https://gitlab.com
   * @param clientId the client id given to you by GitLab
   * @param clientSecret the client secret given to you by GitLab
   * @return 
   */
  public static io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth create(io.vertx.mutiny.core.Vertx vertx, String site, String clientId, String clientSecret) { 
    io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth ret = io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)io.vertx.ext.auth.oauth2.providers.GitLabAuth.create(vertx.getDelegate(), site, clientId, clientSecret));
    return ret;
  }

  /**
   * @param vertx 
   * @param site root URL for the provider without trailing slashes, eg. https://gitlab.com
   * @param clientId the client id given to you by GitLab
   * @param clientSecret the client secret given to you by GitLab
   * @param httpClientOptions custom http client options
   * @return 
   */
  public static io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth create(io.vertx.mutiny.core.Vertx vertx, String site, String clientId, String clientSecret, io.vertx.core.http.HttpClientOptions httpClientOptions) { 
    io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth ret = io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)io.vertx.ext.auth.oauth2.providers.GitLabAuth.create(vertx.getDelegate(), site, clientId, clientSecret, httpClientOptions));
    return ret;
  }

  public static  GitLabAuth newInstance(io.vertx.ext.auth.oauth2.providers.GitLabAuth arg) {
    return arg != null ? new GitLabAuth(arg) : null;
  }

}
