/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.uni;

import io.smallrye.mutiny.Context;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;

public class UniMemoizeOp<I>
extends UniOperator<I, I>
implements UniSubscriber<I> {
    private final BooleanSupplier invalidationRequested;
    private final AtomicReference<State> state = new AtomicReference<State>(State.INIT);
    private final AtomicInteger wip = new AtomicInteger();
    private final List<UniSubscriberWrapper<? super I>> subscribers = Collections.synchronizedList(new ArrayList());
    private volatile UniSubscription upstreamSubscription;
    private volatile I item;
    private volatile Throwable failure;
    private volatile Context lastContextInUse;

    public UniMemoizeOp(Uni<? extends I> upstream) {
        this(upstream, () -> false);
    }

    public UniMemoizeOp(Uni<? extends I> upstream, BooleanSupplier invalidationRequested) {
        super(ParameterValidation.nonNull(upstream, "upstream"));
        this.invalidationRequested = invalidationRequested;
    }

    @Override
    public Context context() {
        return this.lastContextInUse;
    }

    @Override
    public void subscribe(UniSubscriber<? super I> subscriber) {
        if (this.invalidationRequested.getAsBoolean() && this.state.get() != State.SUBSCRIBING) {
            this.state.set(State.INIT);
            if (this.upstreamSubscription != null) {
                this.upstreamSubscription.cancel();
            }
        }
        UniSubscriberWrapper<I> wrapper = new UniSubscriberWrapper<I>(subscriber);
        if (this.state.get() == State.CACHING) {
            subscriber.onSubscribe(wrapper::markCancelled);
            if (!wrapper.isCancelled()) {
                if (this.failure != null) {
                    subscriber.onFailure(this.failure);
                } else {
                    subscriber.onItem(this.item);
                }
            }
            return;
        }
        this.subscribers.add(wrapper);
        if (this.state.compareAndSet(State.INIT, State.SUBSCRIBING)) {
            this.lastContextInUse = subscriber.context();
            AbstractUni.subscribe(this.upstream(), this);
        }
        this.drain();
    }

    @Override
    public void onSubscribe(UniSubscription subscription) {
        if (this.state.compareAndSet(State.SUBSCRIBING, State.SUBSCRIBED)) {
            this.upstreamSubscription = subscription;
            this.drain();
        } else {
            subscription.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drain() {
        if (this.wip.getAndIncrement() != 0) {
            return;
        }
        int missed = 1;
        do {
            ArrayList<UniSubscriberWrapper<I>> wrappers;
            if (this.subscribers.isEmpty()) continue;
            List<UniSubscriberWrapper<? super I>> list = this.subscribers;
            synchronized (list) {
                wrappers = new ArrayList<UniSubscriberWrapper<I>>(this.subscribers);
            }
            block12: for (UniSubscriberWrapper uniSubscriberWrapper : wrappers) {
                if (uniSubscriberWrapper.isCancelled()) {
                    this.subscribers.remove(uniSubscriberWrapper);
                    continue;
                }
                I currentItem = this.item;
                Throwable currentFailure = this.failure;
                State state = this.state.get();
                if (uniSubscriberWrapper.isAwaitingSubscription()) {
                    switch (state) {
                        case INIT: 
                        case SUBSCRIBING: {
                            continue block12;
                        }
                        case SUBSCRIBED: {
                            uniSubscriberWrapper.subscriber.onSubscribe(uniSubscriberWrapper::markCancelled);
                            uniSubscriberWrapper.markSubscribed();
                            continue block12;
                        }
                        case CACHING: {
                            uniSubscriberWrapper.subscriber.onSubscribe(uniSubscriberWrapper::markCancelled);
                            uniSubscriberWrapper.markSubscribed();
                            try {
                                if (uniSubscriberWrapper.isCancelled()) continue block12;
                                if (currentFailure != null) {
                                    uniSubscriberWrapper.subscriber.onFailure(currentFailure);
                                    continue block12;
                                }
                                uniSubscriberWrapper.subscriber.onItem(currentItem);
                                continue block12;
                            }
                            finally {
                                this.subscribers.remove(uniSubscriberWrapper);
                                continue block12;
                            }
                        }
                        default: {
                            throw new IllegalStateException("Current state is " + state);
                        }
                    }
                }
                if (state != State.CACHING || !uniSubscriberWrapper.isAwaitingResult()) continue;
                if (this.failure != null) {
                    uniSubscriberWrapper.subscriber.onFailure(currentFailure);
                } else {
                    uniSubscriberWrapper.subscriber.onItem(currentItem);
                }
                this.subscribers.remove(uniSubscriberWrapper);
            }
        } while ((missed = this.wip.addAndGet(-missed)) != 0);
    }

    @Override
    public void onItem(I item) {
        if (this.state.get() == State.SUBSCRIBED) {
            this.item = item;
            this.failure = null;
            this.state.set(State.CACHING);
            this.drain();
        }
    }

    @Override
    public void onFailure(Throwable failure) {
        if (this.state.get() == State.SUBSCRIBED) {
            this.item = null;
            this.failure = failure;
            this.state.set(State.CACHING);
            this.drain();
        }
    }

    private static class UniSubscriberWrapper<I> {
        final UniSubscriber<? super I> subscriber;
        final AtomicReference<Status> status = new AtomicReference<Status>(Status.AWAITING_SUBSCRIPTION);

        UniSubscriberWrapper(UniSubscriber<? super I> subscriber) {
            this.subscriber = subscriber;
        }

        void markCancelled() {
            this.status.set(Status.CANCELLED);
        }

        void markSubscribed() {
            this.status.compareAndSet(Status.AWAITING_SUBSCRIPTION, Status.AWAITING_RESULT);
        }

        boolean isCancelled() {
            return this.status.get() == Status.CANCELLED;
        }

        boolean isAwaitingSubscription() {
            return this.status.get() == Status.AWAITING_SUBSCRIPTION;
        }

        boolean isAwaitingResult() {
            return this.status.get() == Status.AWAITING_RESULT;
        }

        static enum Status {
            AWAITING_SUBSCRIPTION,
            AWAITING_RESULT,
            CANCELLED;

        }
    }

    private static enum State {
        INIT,
        SUBSCRIBING,
        SUBSCRIBED,
        CACHING;

    }
}

