/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.version;

import io.smallrye.common.constraint.Assert;
import io.smallrye.common.version.Messages;
import io.smallrye.common.version.VersionIterator;
import io.smallrye.common.version.VersionSyntaxException;
import java.util.NoSuchElementException;

public abstract class AbstractVersionIterator
implements VersionIterator {
    protected final String string;
    long cookie;

    protected AbstractVersionIterator(String string) {
        this.string = (String)Assert.checkNotNullParam((String)"string", (Object)string);
    }

    static long makeCookie(long start, long end, TokenType state, long extraBits) {
        return start | end << 12 | ((long)state.ordinal() << 24 | extraBits << 32);
    }

    static int cookieToStartIndex(long cookie) {
        return (int)(cookie & 0x3FFL);
    }

    static int cookieToEndIndex(long cookie) {
        return (int)(cookie >> 12 & 0x3FFL);
    }

    static TokenType cookieType(long cookie) {
        return TokenType.values[(int)(cookie >> 24 & 0xFL)];
    }

    static int cookieToExtraBits(long cookie) {
        return (int)(cookie >> 32);
    }

    protected void changeType(TokenType newType) {
        long cookie = this.cookie;
        this.cookie = AbstractVersionIterator.makeCookie(AbstractVersionIterator.cookieToStartIndex(cookie), AbstractVersionIterator.cookieToEndIndex(cookie), (TokenType)((Object)Assert.checkNotNullParam((String)"newState", (Object)((Object)newType))), AbstractVersionIterator.cookieToExtraBits(cookie));
    }

    protected void insertEmptyAlpha() {
        long cookie = this.cookie;
        this.setCurrentToken(TokenType.PART_ALPHA, AbstractVersionIterator.cookieToStartIndex(cookie), AbstractVersionIterator.cookieToStartIndex(cookie), AbstractVersionIterator.cookieToExtraBits(cookie));
    }

    protected void insertEmptySeparator() {
        long cookie = this.cookie;
        this.setCurrentToken(TokenType.SEP_EMPTY, AbstractVersionIterator.cookieToStartIndex(cookie), AbstractVersionIterator.cookieToStartIndex(cookie), AbstractVersionIterator.cookieToExtraBits(cookie));
    }

    protected void insertEmptyNumber() {
        long cookie = this.cookie;
        this.setCurrentToken(TokenType.PART_NUMBER, AbstractVersionIterator.cookieToStartIndex(cookie), AbstractVersionIterator.cookieToStartIndex(cookie), AbstractVersionIterator.cookieToExtraBits(cookie));
    }

    protected void setCurrentToken(TokenType tokenType, int startIndex, int endIndex, int extraBits) {
        this.cookie = AbstractVersionIterator.makeCookie(startIndex, endIndex, (TokenType)((Object)Assert.checkNotNullParam((String)"tokenType", (Object)((Object)tokenType))), extraBits);
    }

    protected long mark() {
        return this.cookie;
    }

    protected void reset(long mark) {
        this.cookie = mark;
    }

    protected TokenType currentType() {
        return AbstractVersionIterator.cookieType(this.cookie);
    }

    protected int getStartIndex() {
        return AbstractVersionIterator.cookieToStartIndex(this.cookie);
    }

    protected int getEndIndex() {
        return AbstractVersionIterator.cookieToEndIndex(this.cookie);
    }

    protected int getExtraBits() {
        return AbstractVersionIterator.cookieToExtraBits(this.cookie);
    }

    @Override
    public int compareAlphaPart(String str, int offs, int len, boolean ignoreCase) throws IllegalStateException, StringIndexOutOfBoundsException {
        int ocp;
        int cp;
        long cookie = this.cookie;
        int myOffs = AbstractVersionIterator.cookieToStartIndex(cookie);
        int myLen = AbstractVersionIterator.cookieToEndIndex(cookie) - myOffs;
        int i = 0;
        for (int j = 0; i < myLen && j < len; i += Character.charCount(cp), j += Character.charCount(ocp)) {
            int res;
            cp = this.string.codePointAt(i + myOffs);
            ocp = str.codePointAt(j + offs);
            if (ignoreCase) {
                res = Integer.compare(Character.toLowerCase(cp), Character.toLowerCase(ocp));
                if (res == 0) {
                    res = Integer.compare(Character.toUpperCase(cp), Character.toUpperCase(ocp));
                }
            } else {
                res = Integer.compare(cp, ocp);
            }
            if (res == 0) continue;
            return res;
        }
        return Integer.compare(len, myLen);
    }

    @Override
    public int compareAlphaPart(VersionIterator other, boolean ignoreCase) throws IllegalStateException {
        long cookie = this.cookie;
        if (AbstractVersionIterator.cookieType(cookie) != TokenType.PART_ALPHA) {
            throw Messages.msg.expectedAlpha();
        }
        int start = AbstractVersionIterator.cookieToStartIndex(cookie);
        return -Integer.signum(other.compareAlphaPart(this.string, start, AbstractVersionIterator.cookieToEndIndex(cookie) - start, ignoreCase));
    }

    @Override
    public int length() {
        long cookie = this.cookie;
        return AbstractVersionIterator.cookieToEndIndex(cookie) - AbstractVersionIterator.cookieToStartIndex(cookie);
    }

    @Override
    public String getNumberPartAsString() throws IllegalStateException {
        long cookie = this.cookie;
        if (AbstractVersionIterator.cookieType(cookie) != TokenType.PART_NUMBER) {
            throw Messages.msg.expectedNumber();
        }
        return this.string.substring(AbstractVersionIterator.cookieToStartIndex(cookie), AbstractVersionIterator.cookieToEndIndex(cookie));
    }

    @Override
    public StringBuilder appendNumberPartTo(StringBuilder target) throws IllegalStateException {
        int cp;
        long cookie = this.cookie;
        if (AbstractVersionIterator.cookieType(cookie) != TokenType.PART_NUMBER) {
            throw Messages.msg.expectedNumber();
        }
        int start = AbstractVersionIterator.cookieToStartIndex(cookie);
        int end = AbstractVersionIterator.cookieToEndIndex(cookie);
        boolean nz = false;
        for (int i = start; i < end; i += Character.charCount(cp)) {
            cp = this.string.codePointAt(i);
            int v = this.numericCodePointValue(cp);
            assert (v >= 0);
            if (v == 0 && !nz) continue;
            target.appendCodePoint(48 + v);
            nz = true;
        }
        return target;
    }

    @Override
    public int getNumberPartAsInt() {
        return (int)this.getNumberPartAsLong();
    }

    @Override
    public long getNumberPartAsLong() {
        int cp;
        long cookie = this.cookie;
        if (AbstractVersionIterator.cookieType(cookie) != TokenType.PART_NUMBER) {
            throw Messages.msg.expectedNumber();
        }
        long total = 0L;
        int start = AbstractVersionIterator.cookieToStartIndex(cookie);
        int end = AbstractVersionIterator.cookieToEndIndex(cookie);
        for (int i = start; i < end; i += Character.charCount(cp)) {
            cp = this.string.codePointAt(i);
            int v = this.numericCodePointValue(cp);
            assert (v >= 0);
            total = total * 10L + (long)v;
        }
        return total;
    }

    @Override
    public int compareNumberPart(int value) throws IllegalStateException {
        int cp;
        long cookie = this.cookie;
        if (AbstractVersionIterator.cookieType(cookie) != TokenType.PART_NUMBER) {
            throw Messages.msg.expectedNumber();
        }
        long total = 0L;
        int start = AbstractVersionIterator.cookieToStartIndex(cookie);
        int end = AbstractVersionIterator.cookieToEndIndex(cookie);
        long ul = Integer.toUnsignedLong(value);
        for (int i = start; i < end; i += Character.charCount(cp)) {
            cp = this.string.codePointAt(i);
            int v = this.numericCodePointValue(cp);
            assert (v >= 0);
            if ((total = total * 10L + (long)v) <= ul) continue;
            return 1;
        }
        return total == (long)value ? 0 : -1;
    }

    @Override
    public int compareNumberPart(long value) throws IllegalStateException {
        long cookie = this.cookie;
        if (AbstractVersionIterator.cookieType(cookie) != TokenType.PART_NUMBER) {
            throw Messages.msg.expectedNumber();
        }
        long total = 0L;
        int start = AbstractVersionIterator.cookieToStartIndex(cookie);
        int end = AbstractVersionIterator.cookieToEndIndex(cookie);
        try {
            int cp;
            for (int i = start; i < end; i += Character.charCount(cp)) {
                cp = this.string.codePointAt(i);
                int v = this.numericCodePointValue(cp);
                assert (v >= 0);
                if (Long.compareUnsigned(total = Math.addExact(Math.multiplyExact(total, 10L), (long)v), value) <= 0) continue;
                return 1;
            }
        }
        catch (ArithmeticException ignored) {
            return 1;
        }
        return total == value ? 0 : -1;
    }

    @Override
    public int compareNumberPart(String value, int offs, int len) throws IllegalStateException {
        int ocp;
        int ov;
        int cp;
        int v;
        int myLen;
        int cnt;
        long cookie = this.cookie;
        if (AbstractVersionIterator.cookieType(cookie) != TokenType.PART_NUMBER) {
            throw Messages.msg.expectedNumber();
        }
        int start = AbstractVersionIterator.cookieToStartIndex(cookie);
        int res = 0;
        int j = 0;
        int i = 0;
        for (myLen = AbstractVersionIterator.cookieToEndIndex(cookie) - start; i < myLen && (v = this.numericCodePointValue(cp = this.string.codePointAt(i + start))) == 0; myLen -= cnt) {
            cnt = Character.charCount(cp);
            start += cnt;
        }
        while (j < len && (ov = this.numericCodePointValue(ocp = value.codePointAt(j + offs))) == 0) {
            cnt = Character.charCount(ocp);
            offs += cnt;
            len -= cnt;
        }
        while (i < myLen && j < len) {
            cp = this.string.codePointAt(i + start);
            v = this.numericCodePointValue(cp);
            if (v == -1) {
                throw Messages.msg.invalidCodePoint(new String(Character.toChars(cp)), start + i, this.string);
            }
            ocp = value.codePointAt(j + offs);
            ov = this.numericCodePointValue(ocp);
            if (ov == -1) {
                throw Messages.msg.nonNumeric(new String(Character.toChars(cp)), offs + j, value);
            }
            if (res == 0) {
                res = Integer.compare(v, ov);
            }
            i += Character.charCount(cp);
            j += Character.charCount(ocp);
        }
        return i < myLen ? 1 : (j < len ? -1 : res);
    }

    @Override
    public int compareNumberPart(VersionIterator other) {
        long cookie = this.cookie;
        if (AbstractVersionIterator.cookieType(cookie) != TokenType.PART_NUMBER) {
            throw Messages.msg.expectedNumber();
        }
        int start = AbstractVersionIterator.cookieToStartIndex(cookie);
        int len = AbstractVersionIterator.cookieToEndIndex(cookie) - start;
        return -Integer.signum(other.compareNumberPart(this.string, start, len));
    }

    @Override
    public boolean isPart() {
        TokenType tokenType = AbstractVersionIterator.cookieType(this.cookie);
        return tokenType == TokenType.PART_ALPHA || tokenType == TokenType.PART_NUMBER;
    }

    @Override
    public boolean isSeparator() {
        TokenType tokenType = AbstractVersionIterator.cookieType(this.cookie);
        return tokenType == TokenType.SEP || tokenType == TokenType.SEP_EMPTY;
    }

    @Override
    public boolean isEmptySeparator() {
        return AbstractVersionIterator.cookieType(this.cookie) == TokenType.SEP_EMPTY;
    }

    @Override
    public boolean isNonEmptySeparator() {
        return AbstractVersionIterator.cookieType(this.cookie) == TokenType.SEP;
    }

    @Override
    public int getSeparatorCodePoint() {
        long cookie = this.cookie;
        if (AbstractVersionIterator.cookieType(cookie) != TokenType.SEP) {
            throw Messages.msg.expectedSep();
        }
        return this.string.codePointAt(AbstractVersionIterator.cookieToStartIndex(cookie));
    }

    @Override
    public boolean isAlphaPart() {
        return AbstractVersionIterator.cookieType(this.cookie) == TokenType.PART_ALPHA;
    }

    @Override
    public boolean isNumberPart() {
        return AbstractVersionIterator.cookieType(this.cookie) == TokenType.PART_NUMBER;
    }

    @Override
    public String getAlphaPart() throws IllegalStateException {
        long cookie = this.cookie;
        if (AbstractVersionIterator.cookieType(cookie) != TokenType.PART_ALPHA) {
            throw Messages.msg.expectedAlpha();
        }
        return this.string.substring(AbstractVersionIterator.cookieToStartIndex(cookie), AbstractVersionIterator.cookieToEndIndex(cookie));
    }

    @Override
    public StringBuilder appendAlphaPartTo(StringBuilder target) throws IllegalStateException {
        long cookie = this.cookie;
        if (AbstractVersionIterator.cookieType(cookie) != TokenType.PART_ALPHA) {
            throw Messages.msg.expectedAlpha();
        }
        return target.append(this.string, AbstractVersionIterator.cookieToStartIndex(cookie), AbstractVersionIterator.cookieToEndIndex(cookie));
    }

    @Override
    public StringBuilder appendPartTo(StringBuilder target) {
        Assert.checkNotNullParam((String)"target", (Object)target);
        TokenType tokenType = AbstractVersionIterator.cookieType(this.cookie);
        if (tokenType == TokenType.PART_NUMBER) {
            return this.appendNumberPartTo(target);
        }
        if (tokenType == TokenType.PART_ALPHA) {
            return this.appendAlphaPartTo(target);
        }
        if (tokenType == TokenType.SEP) {
            return target.appendCodePoint(this.getSeparatorCodePoint());
        }
        return target;
    }

    @Override
    public boolean hasNext() {
        return this.thisHasNext();
    }

    private boolean thisHasNext() {
        return AbstractVersionIterator.cookieToEndIndex(this.cookie) < this.string.length();
    }

    protected boolean isSeparatorCodePoint(int cp) {
        return cp == 46 || cp == 45 || cp == 43 || cp == 95;
    }

    protected int numericCodePointValue(int cp) {
        return Character.digit(cp, 10);
    }

    protected boolean isAlphaCodePoint(int cp) {
        return Character.isLetter(cp);
    }

    @Override
    public void next() throws NoSuchElementException, VersionSyntaxException {
        if (!this.thisHasNext()) {
            throw Messages.msg.iterationPastEnd();
        }
        long cookie = this.cookie;
        int end = AbstractVersionIterator.cookieToEndIndex(cookie);
        int bits = AbstractVersionIterator.cookieToExtraBits(cookie);
        String string = this.string;
        int length = string.length();
        assert (end < length);
        int start = end;
        int cp = string.codePointAt(start);
        TokenType token = AbstractVersionIterator.cookieType(cookie);
        if (!(token != TokenType.PART_NUMBER && token != TokenType.PART_ALPHA || !this.isAlphaCodePoint(cp) && this.numericCodePointValue(cp) == -1)) {
            token = TokenType.SEP_EMPTY;
            end = start;
        } else if (this.isAlphaCodePoint(cp)) {
            token = TokenType.PART_ALPHA;
            end = length;
            for (int i = start + Character.charCount(cp); i < length; i += Character.charCount(cp)) {
                cp = string.codePointAt(i);
                if (this.isAlphaCodePoint(cp)) continue;
                end = i;
                break;
            }
        } else if (this.numericCodePointValue(cp) != -1) {
            token = TokenType.PART_NUMBER;
            end = length;
            int i = 0;
            while (start + i < length) {
                cp = string.codePointAt(i + start);
                int d = this.numericCodePointValue(cp);
                if (d == -1) {
                    end = start + i;
                    break;
                }
                if (d == 0 && i == 0) {
                    start += Character.charCount(cp);
                    continue;
                }
                i += Character.charCount(cp);
            }
            if (end == start) {
                start = end - 1;
            }
        } else if (this.isSeparatorCodePoint(cp)) {
            token = TokenType.SEP;
            end = start + Character.charCount(cp);
        } else {
            throw Messages.msg.invalidCodePoint(new String(Character.toChars(cp)), start, string);
        }
        if (end >= 4096) {
            throw Messages.msg.tooLong();
        }
        assert (end >= start);
        this.cookie = AbstractVersionIterator.makeCookie(start, end, token, bits);
    }

    public String toString() {
        StringBuilder b = new StringBuilder(this.string);
        b.insert(this.getEndIndex(), ">");
        b.insert(this.getStartIndex(), "<");
        b.append(' ').append((Object)this.currentType());
        return b.toString();
    }

    protected static enum TokenType {
        INITIAL,
        PART_ALPHA,
        PART_NUMBER,
        SEP_EMPTY,
        SEP,
        INVALID;

        static TokenType[] values;

        static {
            values = TokenType.values();
        }
    }
}

