/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.certs;

import io.smallrye.certs.CertificateRequest;
import io.smallrye.certs.CertificateUtils;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.List;

public class CertificateHolder {
    private final KeyPair keys;
    private final X509Certificate certificate;
    private final KeyPair clientKeys;
    private final X509Certificate clientCertificate;
    private final String password;
    private final CertificateRequest.Issuer issuer;

    public CertificateHolder(String cn, List<String> sans, Duration duration, boolean generateClient, String password, CertificateRequest.Issuer issuer) throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(2048);
        this.issuer = issuer;
        this.keys = keyPairGenerator.generateKeyPair();
        this.certificate = CertificateUtils.generateCertificate(this.keys, cn, sans, duration, issuer);
        if (generateClient) {
            this.clientKeys = keyPairGenerator.generateKeyPair();
            this.clientCertificate = CertificateUtils.generateCertificate(this.clientKeys, cn, sans, duration, issuer);
        } else {
            this.clientKeys = null;
            this.clientCertificate = null;
        }
        this.password = password;
    }

    public KeyPair keys() {
        return this.keys;
    }

    public X509Certificate certificate() {
        return this.certificate;
    }

    public KeyPair clientKeys() {
        return this.clientKeys;
    }

    public X509Certificate clientCertificate() {
        return this.clientCertificate;
    }

    public boolean hasClient() {
        return this.clientKeys != null;
    }

    public CertificateRequest.Issuer issuer() {
        return this.issuer;
    }

    public char[] password() {
        if (this.password == null) {
            return null;
        }
        return this.password.toCharArray();
    }
}

