/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.transaction.core.loader;

import io.shardingsphere.core.constant.transaction.TransactionType;
import io.shardingsphere.transaction.core.internal.context.ShardingTransactionContext;
import io.shardingsphere.transaction.spi.ShardingTransactionHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShardingTransactionHandlerRegistry {
    private static final Logger log = LoggerFactory.getLogger(ShardingTransactionHandlerRegistry.class);
    private static final Map<TransactionType, ShardingTransactionHandler<ShardingTransactionContext>> TRANSACTION_HANDLER_MAP = new HashMap<TransactionType, ShardingTransactionHandler<ShardingTransactionContext>>();
    private static final ShardingTransactionHandlerRegistry INSTANCE = new ShardingTransactionHandlerRegistry();

    private static void load() {
        for (ShardingTransactionHandler each : ServiceLoader.load(ShardingTransactionHandler.class)) {
            if (TRANSACTION_HANDLER_MAP.containsKey(each.getTransactionType())) {
                log.warn("Find more than one {} transaction handler implementation class, use `{}` now", (Object)each.getTransactionType(), (Object)TRANSACTION_HANDLER_MAP.get(each.getTransactionType()).getClass().getName());
                continue;
            }
            TRANSACTION_HANDLER_MAP.put(each.getTransactionType(), each);
        }
    }

    public static ShardingTransactionHandlerRegistry getInstance() {
        return INSTANCE;
    }

    public ShardingTransactionHandler<ShardingTransactionContext> getHandler(TransactionType transactionType) {
        return TRANSACTION_HANDLER_MAP.get(transactionType);
    }

    private ShardingTransactionHandlerRegistry() {
    }

    static {
        ShardingTransactionHandlerRegistry.load();
    }
}

