/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.validation;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.serverlessworkflow.api.Workflow;
import io.serverlessworkflow.api.actions.Action;
import io.serverlessworkflow.api.events.EventDefinition;
import io.serverlessworkflow.api.events.OnEvents;
import io.serverlessworkflow.api.functions.FunctionDefinition;
import io.serverlessworkflow.api.interfaces.State;
import io.serverlessworkflow.api.interfaces.WorkflowValidator;
import io.serverlessworkflow.api.states.CallbackState;
import io.serverlessworkflow.api.states.EventState;
import io.serverlessworkflow.api.states.ForEachState;
import io.serverlessworkflow.api.states.InjectState;
import io.serverlessworkflow.api.states.OperationState;
import io.serverlessworkflow.api.states.ParallelState;
import io.serverlessworkflow.api.states.SleepState;
import io.serverlessworkflow.api.states.SwitchState;
import io.serverlessworkflow.api.switchconditions.DataCondition;
import io.serverlessworkflow.api.switchconditions.EventCondition;
import io.serverlessworkflow.api.validation.ValidationError;
import io.serverlessworkflow.api.validation.WorkflowSchemaLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowValidatorImpl
implements WorkflowValidator {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowValidatorImpl.class);
    private boolean schemaValidationEnabled = true;
    private List<ValidationError> validationErrors = new ArrayList<ValidationError>();
    private Schema workflowSchema = WorkflowSchemaLoader.getWorkflowSchema();
    private String source;
    private Workflow workflow;

    public WorkflowValidator setWorkflow(Workflow workflow) {
        this.workflow = workflow;
        return this;
    }

    public WorkflowValidator setSource(String source) {
        this.source = source;
        return this;
    }

    public List<ValidationError> validate() {
        List events;
        block18: {
            this.validationErrors.clear();
            if (this.workflow == null) {
                try {
                    if (!this.schemaValidationEnabled || this.source == null) break block18;
                    try {
                        if (!this.source.trim().startsWith("{")) {
                            ObjectMapper yamlReader = new ObjectMapper((JsonFactory)new YAMLFactory());
                            Object obj = yamlReader.readValue(this.source, Object.class);
                            ObjectMapper jsonWriter = new ObjectMapper();
                            this.workflowSchema.validate((Object)new JSONObject(jsonWriter.writeValueAsString(obj)));
                            break block18;
                        }
                        this.workflowSchema.validate((Object)new JSONObject(this.source));
                    }
                    catch (ValidationException e) {
                        e.getCausingExceptions().stream().map(ValidationException::getMessage).forEach(m -> {
                            if (!(m.equals("#/functions: expected type: JSONObject, found: JSONArray") || m.equals("#/events: expected type: JSONObject, found: JSONArray") || m.equals("#/start: expected type: JSONObject, found: String") || m.equals("#/retries: expected type: JSONObject, found: JSONArray"))) {
                                this.addValidationError((String)m, "schemavalidation");
                            }
                        });
                    }
                }
                catch (Exception e) {
                    logger.error("Schema validation exception: " + e.getMessage());
                }
            }
        }
        if (this.validationErrors.size() > 0) {
            return this.validationErrors;
        }
        if (this.workflow == null) {
            this.workflow = Workflow.fromSource((String)this.source);
        }
        List functions = this.workflow.getFunctions() != null ? this.workflow.getFunctions().getFunctionDefs() : null;
        List list = events = this.workflow.getEvents() != null ? this.workflow.getEvents().getEventDefs() : null;
        if (this.workflow.getId() == null || this.workflow.getId().trim().isEmpty()) {
            this.addValidationError("Workflow id should not be empty", "workflowvalidation");
        }
        if (this.workflow.getVersion() == null || this.workflow.getVersion().trim().isEmpty()) {
            this.addValidationError("Workflow version should not be empty", "workflowvalidation");
        }
        if (this.workflow.getStates() == null || this.workflow.getStates().isEmpty()) {
            this.addValidationError("No states found", "workflowvalidation");
        }
        if (this.workflow.getStates() != null && !this.workflow.getStates().isEmpty()) {
            boolean existingStateWithStartProperty = false;
            if (this.workflow.getStart() != null) {
                String startProperty = this.workflow.getStart().getStateName();
                for (State s2 : this.workflow.getStates()) {
                    if (!s2.getName().equals(startProperty)) continue;
                    existingStateWithStartProperty = true;
                    break;
                }
            } else {
                existingStateWithStartProperty = true;
            }
            if (!existingStateWithStartProperty) {
                this.addValidationError("No state name found that matches the workflow start definition", "workflowvalidation");
            }
        }
        Validation validation = new Validation();
        if (this.workflow.getStates() != null && !this.workflow.getStates().isEmpty()) {
            this.workflow.getStates().forEach(s -> {
                ForEachState forEachState;
                InjectState injectState;
                ParallelState parallelState;
                SleepState sleepState;
                if (s.getName() != null && s.getName().trim().isEmpty()) {
                    this.addValidationError("State name should not be empty", "workflowvalidation");
                } else {
                    validation.addState(s.getName());
                }
                if (s.getEnd() != null) {
                    validation.addEndState();
                }
                if (s instanceof OperationState) {
                    OperationState operationState = (OperationState)s;
                    List actions = operationState.getActions();
                    for (Action action : actions) {
                        if (action.getFunctionRef() != null) {
                            if (action.getFunctionRef().getRefName().isEmpty()) {
                                this.addValidationError("Operation State action functionRef should not be null or empty", "workflowvalidation");
                            }
                            if (!this.haveFunctionDefinition(action.getFunctionRef().getRefName(), functions)) {
                                this.addValidationError("Operation State action functionRef does not reference an existing workflow function definition", "workflowvalidation");
                            }
                        }
                        if (action.getEventRef() == null) continue;
                        if (action.getEventRef().getTriggerEventRef().isEmpty()) {
                            this.addValidationError("Operation State action trigger eventRef does not reference an existing workflow event definition", "workflowvalidation");
                        }
                        if (action.getEventRef().getResultEventRef().isEmpty()) {
                            this.addValidationError("Operation State action results eventRef does not reference an existing workflow event definition", "workflowvalidation");
                        }
                        if (!this.haveEventsDefinition(action.getEventRef().getTriggerEventRef(), events)) {
                            this.addValidationError("Operation State action trigger event def does not reference an existing workflow event definition", "workflowvalidation");
                        }
                        if (this.haveEventsDefinition(action.getEventRef().getResultEventRef(), events)) continue;
                        this.addValidationError("Operation State action results event def does not reference an existing workflow event definition", "workflowvalidation");
                    }
                }
                if (s instanceof EventState) {
                    EventState eventState = (EventState)s;
                    if (eventState.getOnEvents() == null || eventState.getOnEvents().size() < 1) {
                        this.addValidationError("Event State has no eventActions defined", "workflowvalidation");
                    }
                    List eventsActionsList = eventState.getOnEvents();
                    for (OnEvents onEvents : eventsActionsList) {
                        List eventRefs = onEvents.getEventRefs();
                        if (eventRefs == null || eventRefs.size() < 1) {
                            this.addValidationError("Event State eventsActions has no event refs", "workflowvalidation");
                            continue;
                        }
                        for (String eventRef : eventRefs) {
                            if (this.haveEventsDefinition(eventRef, events)) continue;
                            this.addValidationError("Event State eventsActions eventRef does not match a declared workflow event definition", "workflowvalidation");
                        }
                    }
                }
                if (s instanceof SwitchState) {
                    SwitchState switchState = (SwitchState)s;
                    if (!(switchState.getDataConditions() != null && switchState.getDataConditions().size() >= 1 || switchState.getEventConditions() != null && switchState.getEventConditions().size() >= 1)) {
                        this.addValidationError("Switch state should define either data or event conditions", "workflowvalidation");
                    }
                    if (switchState.getDefaultCondition() == null) {
                        this.addValidationError("Switch state should define a default transition", "workflowvalidation");
                    }
                    if (switchState.getEventConditions() != null && switchState.getEventConditions().size() > 0) {
                        List eventConditions = switchState.getEventConditions();
                        for (EventCondition ec : eventConditions) {
                            if (!this.haveEventsDefinition(ec.getEventRef(), events)) {
                                this.addValidationError("Switch state event condition eventRef does not reference a defined workflow event", "workflowvalidation");
                            }
                            if (ec.getEnd() == null) continue;
                            validation.addEndState();
                        }
                    }
                    if (switchState.getDataConditions() != null && switchState.getDataConditions().size() > 0) {
                        List dataConditions = switchState.getDataConditions();
                        for (DataCondition dc : dataConditions) {
                            if (dc.getEnd() == null) continue;
                            validation.addEndState();
                        }
                    }
                }
                if (s instanceof SleepState && ((sleepState = (SleepState)s).getDuration() == null || sleepState.getDuration().length() < 1)) {
                    this.addValidationError("Sleep state should have a non-empty time delay", "workflowvalidation");
                }
                if (s instanceof ParallelState && ((parallelState = (ParallelState)s).getBranches() == null || parallelState.getBranches().size() < 2)) {
                    this.addValidationError("Parallel state should have at lest two branches", "workflowvalidation");
                }
                if (s instanceof InjectState && ((injectState = (InjectState)s).getData() == null || injectState.getData().isEmpty())) {
                    this.addValidationError("InjectState should have non-null data", "workflowvalidation");
                }
                if (s instanceof ForEachState && ((forEachState = (ForEachState)s).getInputCollection() == null || forEachState.getInputCollection().isEmpty())) {
                    this.addValidationError("ForEach state should have a valid inputCollection", "workflowvalidation");
                }
                if (s instanceof CallbackState) {
                    CallbackState callbackState = (CallbackState)s;
                    if (!this.haveEventsDefinition(callbackState.getEventRef(), events)) {
                        this.addValidationError("CallbackState event ref does not reference a defined workflow event definition", "workflowvalidation");
                    }
                    if (!this.haveFunctionDefinition(callbackState.getAction().getFunctionRef().getRefName(), functions)) {
                        this.addValidationError("CallbackState action function ref does not reference a defined workflow function definition", "workflowvalidation");
                    }
                }
            });
            if (validation.endStates == 0) {
                this.addValidationError("No end state found.", "workflowvalidation");
            }
        }
        return this.validationErrors;
    }

    public boolean isValid() {
        return this.validate().size() < 1;
    }

    public WorkflowValidator setSchemaValidationEnabled(boolean schemaValidationEnabled) {
        this.schemaValidationEnabled = schemaValidationEnabled;
        return this;
    }

    public WorkflowValidator reset() {
        this.workflow = null;
        this.validationErrors.clear();
        this.schemaValidationEnabled = true;
        return this;
    }

    private boolean haveFunctionDefinition(String functionName, List<FunctionDefinition> functions) {
        if (functions != null) {
            FunctionDefinition fun = functions.stream().filter(f -> f.getName().equals(functionName)).findFirst().orElse(null);
            return fun != null;
        }
        return false;
    }

    private boolean haveEventsDefinition(String eventName, List<EventDefinition> events) {
        if (events != null) {
            EventDefinition eve = events.stream().filter(e -> e.getName().equals(eventName)).findFirst().orElse(null);
            return eve != null;
        }
        return false;
    }

    private void addValidationError(String message, String type) {
        ValidationError mainError = new ValidationError();
        mainError.setMessage(message);
        mainError.setType(type);
        this.validationErrors.add(mainError);
    }

    private class Validation {
        final Set<String> events = new HashSet<String>();
        final Set<String> functions = new HashSet<String>();
        final Set<String> states = new HashSet<String>();
        Integer endStates = 0;

        private Validation() {
        }

        void addFunction(String name) {
            if (this.functions.contains(name)) {
                WorkflowValidatorImpl.this.addValidationError("Function does not have an unique name: " + name, "workflowvalidation");
            } else {
                this.functions.add(name);
            }
        }

        void addEvent(String name) {
            if (this.events.contains(name)) {
                WorkflowValidatorImpl.this.addValidationError("Event does not have an unique name: " + name, "workflowvalidation");
            } else {
                this.events.add(name);
            }
        }

        void addState(String name) {
            if (this.states.contains(name)) {
                WorkflowValidatorImpl.this.addValidationError("State does not have an unique name: " + name, "workflowvalidation");
            } else {
                this.states.add(name);
            }
        }

        void addEndState() {
            Integer n = this.endStates;
            Integer n2 = this.endStates = Integer.valueOf(this.endStates + 1);
        }
    }
}

