/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.serverlessworkflow.api.interfaces.WorkflowPropertySource;
import io.serverlessworkflow.api.utils.Utils;
import io.serverlessworkflow.api.workflow.Secrets;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecretsDeserializer
extends StdDeserializer<Secrets> {
    private static final long serialVersionUID = 510L;
    private static Logger logger = LoggerFactory.getLogger(SecretsDeserializer.class);
    private WorkflowPropertySource context;

    public SecretsDeserializer() {
        this(Secrets.class);
    }

    public SecretsDeserializer(Class<?> vc) {
        super(vc);
    }

    public SecretsDeserializer(WorkflowPropertySource context) {
        this(Secrets.class);
        this.context = context;
    }

    public Secrets deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        Secrets secrets = new Secrets();
        ArrayList<String> secretsDefinitions = new ArrayList<String>();
        if (node.isArray()) {
            for (JsonNode nodeEle : node) {
                secretsDefinitions.add(nodeEle.asText());
            }
        } else {
            String secretsFileDef = node.asText();
            String secretsFileSrc = Utils.getResourceFileAsString(secretsFileDef);
            if (secretsFileSrc != null && secretsFileSrc.trim().length() > 0) {
                JsonNode secretsRefNode = Utils.getNode(secretsFileSrc);
                JsonNode refSecrets = secretsRefNode.get("secrets");
                if (refSecrets != null) {
                    for (JsonNode nodeEle : refSecrets) {
                        secretsDefinitions.add(nodeEle.asText());
                    }
                } else {
                    logger.error("Unable to find secrets definitions in reference file: {}", (Object)secretsFileSrc);
                }
            } else {
                logger.error("Unable to load secrets defs reference file: {}", (Object)secretsFileSrc);
            }
        }
        secrets.setSecretDefs(secretsDefinitions);
        return secrets;
    }
}

