/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.serverlessworkflow.api.error.ErrorDefinition;
import io.serverlessworkflow.api.interfaces.WorkflowPropertySource;
import io.serverlessworkflow.api.utils.Utils;
import io.serverlessworkflow.api.workflow.Errors;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorsDeserializer
extends StdDeserializer<Errors> {
    private static final long serialVersionUID = 510L;
    private static Logger logger = LoggerFactory.getLogger(ErrorsDeserializer.class);
    private WorkflowPropertySource context;

    public ErrorsDeserializer() {
        this(Errors.class);
    }

    public ErrorsDeserializer(Class<?> vc) {
        super(vc);
    }

    public ErrorsDeserializer(WorkflowPropertySource context) {
        this(Errors.class);
        this.context = context;
    }

    public Errors deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        ObjectMapper mapper = (ObjectMapper)jp.getCodec();
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        Errors errors = new Errors();
        ArrayList<ErrorDefinition> errorDefinitions = new ArrayList<ErrorDefinition>();
        if (node.isArray()) {
            for (JsonNode nodeEle : node) {
                errorDefinitions.add((ErrorDefinition)mapper.treeToValue((TreeNode)nodeEle, ErrorDefinition.class));
            }
        } else {
            String errorsFileDef = node.asText();
            String errorsFileSrc = Utils.getResourceFileAsString(errorsFileDef);
            if (errorsFileSrc != null && errorsFileSrc.trim().length() > 0) {
                JsonNode errorsRefNode = Utils.getNode(errorsFileSrc);
                JsonNode refErrors = errorsRefNode.get("errors");
                if (refErrors != null) {
                    for (JsonNode nodeEle : refErrors) {
                        errorDefinitions.add((ErrorDefinition)mapper.treeToValue((TreeNode)nodeEle, ErrorDefinition.class));
                    }
                } else {
                    logger.error("Unable to find error definitions in reference file: {}", (Object)errorsFileSrc);
                }
            } else {
                logger.error("Unable to load errors defs reference file: {}", (Object)errorsFileSrc);
            }
        }
        errors.setErrorDefs(errorDefinitions);
        return errors;
    }
}

