/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.deserializers;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.serverlessworkflow.api.functions.FunctionDefinition;
import io.serverlessworkflow.api.interfaces.WorkflowPropertySource;
import io.serverlessworkflow.api.utils.Utils;
import io.serverlessworkflow.api.workflow.Functions;
import java.io.IOException;
import java.util.ArrayList;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionsDeserializer
extends StdDeserializer<Functions> {
    private static final long serialVersionUID = 510L;
    private static Logger logger = LoggerFactory.getLogger(FunctionsDeserializer.class);
    private WorkflowPropertySource context;

    public FunctionsDeserializer() {
        this(Functions.class);
    }

    public FunctionsDeserializer(Class<?> vc) {
        super(vc);
    }

    public FunctionsDeserializer(WorkflowPropertySource context) {
        this(Functions.class);
        this.context = context;
    }

    public Functions deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        ObjectMapper mapper = (ObjectMapper)jp.getCodec();
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        Functions functions = new Functions();
        ArrayList<FunctionDefinition> functionDefs = new ArrayList<FunctionDefinition>();
        if (node.isArray()) {
            for (JsonNode nodeEle : node) {
                functionDefs.add((FunctionDefinition)mapper.treeToValue((TreeNode)nodeEle, FunctionDefinition.class));
            }
        } else {
            String functionsFileDef = node.asText();
            String functionsFileSrc = Utils.getResourceFileAsString(functionsFileDef);
            ObjectMapper jsonWriter = new ObjectMapper();
            if (functionsFileSrc != null && functionsFileSrc.trim().length() > 0) {
                JsonNode functionsRefNode;
                if (!functionsFileSrc.trim().startsWith("{")) {
                    ObjectMapper yamlReader = new ObjectMapper((JsonFactory)new YAMLFactory());
                    Object obj = yamlReader.readValue(functionsFileSrc, Object.class);
                    functionsRefNode = jsonWriter.readTree(new JSONObject(jsonWriter.writeValueAsString(obj)).toString());
                } else {
                    functionsRefNode = jsonWriter.readTree(new JSONObject(functionsFileSrc).toString());
                }
                JsonNode refFunctions = functionsRefNode.get("functions");
                if (refFunctions != null) {
                    for (JsonNode nodeEle : refFunctions) {
                        functionDefs.add((FunctionDefinition)mapper.treeToValue((TreeNode)nodeEle, FunctionDefinition.class));
                    }
                } else {
                    logger.error("Unable to find function definitions in reference file: {}", (Object)functionsFileSrc);
                }
            } else {
                logger.error("Unable to load function defs reference file: {}", (Object)functionsFileSrc);
            }
        }
        functions.setFunctionDefs(functionDefs);
        return functions;
    }
}

