
package io.serverlessworkflow.api.timeouts;

import java.io.Serializable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "duration",
    "interrupt",
    "runBefore"
})
public class WorkflowExecTimeout implements Serializable
{

    /**
     * Workflow execution timeout duration (ISO 8601 duration format). If not specified should be 'unlimited'
     * (Required)
     * 
     */
    @JsonProperty("duration")
    @JsonPropertyDescription("Workflow execution timeout duration (ISO 8601 duration format). If not specified should be 'unlimited'")
    @Size(min = 1)
    @NotNull
    private String duration;
    /**
     * If `false`, workflow instance is allowed to finish current execution. If `true`, current workflow execution is abrupted.
     * 
     */
    @JsonProperty("interrupt")
    @JsonPropertyDescription("If `false`, workflow instance is allowed to finish current execution. If `true`, current workflow execution is abrupted.")
    private boolean interrupt = true;
    /**
     * Name of a workflow state to be executed before workflow instance is terminated
     * 
     */
    @JsonProperty("runBefore")
    @JsonPropertyDescription("Name of a workflow state to be executed before workflow instance is terminated")
    @Size(min = 1)
    private String runBefore;
    private final static long serialVersionUID = -3406163368108987059L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public WorkflowExecTimeout() {
    }

    /**
     * 
     * @param duration
     */
    public WorkflowExecTimeout(String duration) {
        super();
        this.duration = duration;
    }

    /**
     * Workflow execution timeout duration (ISO 8601 duration format). If not specified should be 'unlimited'
     * (Required)
     * 
     */
    @JsonProperty("duration")
    public String getDuration() {
        return duration;
    }

    /**
     * Workflow execution timeout duration (ISO 8601 duration format). If not specified should be 'unlimited'
     * (Required)
     * 
     */
    @JsonProperty("duration")
    public void setDuration(String duration) {
        this.duration = duration;
    }

    public WorkflowExecTimeout withDuration(String duration) {
        this.duration = duration;
        return this;
    }

    /**
     * If `false`, workflow instance is allowed to finish current execution. If `true`, current workflow execution is abrupted.
     * 
     */
    @JsonProperty("interrupt")
    public boolean isInterrupt() {
        return interrupt;
    }

    /**
     * If `false`, workflow instance is allowed to finish current execution. If `true`, current workflow execution is abrupted.
     * 
     */
    @JsonProperty("interrupt")
    public void setInterrupt(boolean interrupt) {
        this.interrupt = interrupt;
    }

    public WorkflowExecTimeout withInterrupt(boolean interrupt) {
        this.interrupt = interrupt;
        return this;
    }

    /**
     * Name of a workflow state to be executed before workflow instance is terminated
     * 
     */
    @JsonProperty("runBefore")
    public String getRunBefore() {
        return runBefore;
    }

    /**
     * Name of a workflow state to be executed before workflow instance is terminated
     * 
     */
    @JsonProperty("runBefore")
    public void setRunBefore(String runBefore) {
        this.runBefore = runBefore;
    }

    public WorkflowExecTimeout withRunBefore(String runBefore) {
        this.runBefore = runBefore;
        return this;
    }

}
