
package io.serverlessworkflow.api.end;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.serverlessworkflow.api.produce.ProduceEvent;


/**
 * State end definition
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "terminate",
    "produceEvents",
    "compensate",
    "continueAs"
})
public class End implements Serializable
{

    /**
     * If true, completes all execution flows in the given workflow instance
     * 
     */
    @JsonProperty("terminate")
    @JsonPropertyDescription("If true, completes all execution flows in the given workflow instance")
    private boolean terminate = false;
    /**
     * Array of events to be produced
     * 
     */
    @JsonProperty("produceEvents")
    @JsonPropertyDescription("Array of events to be produced")
    @Valid
    private List<ProduceEvent> produceEvents = new ArrayList<ProduceEvent>();
    /**
     * If set to true, triggers workflow compensation when before workflow executin completes. Default is false
     * 
     */
    @JsonProperty("compensate")
    @JsonPropertyDescription("If set to true, triggers workflow compensation when before workflow executin completes. Default is false")
    private boolean compensate = false;
    /**
     * End definition continue as
     * 
     */
    @JsonProperty("continueAs")
    @JsonPropertyDescription("End definition continue as")
    @Valid
    private ContinueAs continueAs;
    private final static long serialVersionUID = 3731296088121348585L;

    /**
     * If true, completes all execution flows in the given workflow instance
     * 
     */
    @JsonProperty("terminate")
    public boolean isTerminate() {
        return terminate;
    }

    /**
     * If true, completes all execution flows in the given workflow instance
     * 
     */
    @JsonProperty("terminate")
    public void setTerminate(boolean terminate) {
        this.terminate = terminate;
    }

    public End withTerminate(boolean terminate) {
        this.terminate = terminate;
        return this;
    }

    /**
     * Array of events to be produced
     * 
     */
    @JsonProperty("produceEvents")
    public List<ProduceEvent> getProduceEvents() {
        return produceEvents;
    }

    /**
     * Array of events to be produced
     * 
     */
    @JsonProperty("produceEvents")
    public void setProduceEvents(List<ProduceEvent> produceEvents) {
        this.produceEvents = produceEvents;
    }

    public End withProduceEvents(List<ProduceEvent> produceEvents) {
        this.produceEvents = produceEvents;
        return this;
    }

    /**
     * If set to true, triggers workflow compensation when before workflow executin completes. Default is false
     * 
     */
    @JsonProperty("compensate")
    public boolean isCompensate() {
        return compensate;
    }

    /**
     * If set to true, triggers workflow compensation when before workflow executin completes. Default is false
     * 
     */
    @JsonProperty("compensate")
    public void setCompensate(boolean compensate) {
        this.compensate = compensate;
    }

    public End withCompensate(boolean compensate) {
        this.compensate = compensate;
        return this;
    }

    /**
     * End definition continue as
     * 
     */
    @JsonProperty("continueAs")
    public ContinueAs getContinueAs() {
        return continueAs;
    }

    /**
     * End definition continue as
     * 
     */
    @JsonProperty("continueAs")
    public void setContinueAs(ContinueAs continueAs) {
        this.continueAs = continueAs;
    }

    public End withContinueAs(ContinueAs continueAs) {
        this.continueAs = continueAs;
        return this;
    }

}
