
package io.serverlessworkflow.api.cron;

import java.io.Serializable;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * Schedule cron definition
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "expression",
    "validUntil"
})
public class Cron implements Serializable
{

    /**
     * Repeating interval (cron expression) describing when the workflow instance should be created
     * (Required)
     * 
     */
    @JsonProperty("expression")
    @JsonPropertyDescription("Repeating interval (cron expression) describing when the workflow instance should be created")
    @NotNull
    private String expression;
    /**
     * Specific date and time (ISO 8601 format) when the cron expression invocation is no longer valid
     * 
     */
    @JsonProperty("validUntil")
    @JsonPropertyDescription("Specific date and time (ISO 8601 format) when the cron expression invocation is no longer valid")
    private String validUntil;
    private final static long serialVersionUID = -5870647120971471707L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Cron() {
    }

    /**
     * 
     * @param expression
     */
    public Cron(String expression) {
        super();
        this.expression = expression;
    }

    /**
     * Repeating interval (cron expression) describing when the workflow instance should be created
     * (Required)
     * 
     */
    @JsonProperty("expression")
    public String getExpression() {
        return expression;
    }

    /**
     * Repeating interval (cron expression) describing when the workflow instance should be created
     * (Required)
     * 
     */
    @JsonProperty("expression")
    public void setExpression(String expression) {
        this.expression = expression;
    }

    public Cron withExpression(String expression) {
        this.expression = expression;
        return this;
    }

    /**
     * Specific date and time (ISO 8601 format) when the cron expression invocation is no longer valid
     * 
     */
    @JsonProperty("validUntil")
    public String getValidUntil() {
        return validUntil;
    }

    /**
     * Specific date and time (ISO 8601 format) when the cron expression invocation is no longer valid
     * 
     */
    @JsonProperty("validUntil")
    public void setValidUntil(String validUntil) {
        this.validUntil = validUntil;
    }

    public Cron withValidUntil(String validUntil) {
        this.validUntil = validUntil;
        return this;
    }

}
