
package io.serverlessworkflow.api.auth;

import java.io.Serializable;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "token",
    "metadata"
})
public class BearerAuthDefinition implements Serializable
{

    /**
     * String or a workflow expression. Contains the token
     * (Required)
     * 
     */
    @JsonProperty("token")
    @JsonPropertyDescription("String or a workflow expression. Contains the token")
    @Size(min = 1)
    @NotNull
    private java.lang.String token;
    /**
     * Metadata
     * 
     */
    @JsonProperty("metadata")
    @JsonPropertyDescription("Metadata")
    @Valid
    private Map<String, String> metadata;
    private final static long serialVersionUID = 5466686267180594730L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public BearerAuthDefinition() {
    }

    /**
     * 
     * @param token
     */
    public BearerAuthDefinition(java.lang.String token) {
        super();
        this.token = token;
    }

    /**
     * String or a workflow expression. Contains the token
     * (Required)
     * 
     */
    @JsonProperty("token")
    public java.lang.String getToken() {
        return token;
    }

    /**
     * String or a workflow expression. Contains the token
     * (Required)
     * 
     */
    @JsonProperty("token")
    public void setToken(java.lang.String token) {
        this.token = token;
    }

    public BearerAuthDefinition withToken(java.lang.String token) {
        this.token = token;
        return this;
    }

    /**
     * Metadata
     * 
     */
    @JsonProperty("metadata")
    public Map<String, String> getMetadata() {
        return metadata;
    }

    /**
     * Metadata
     * 
     */
    @JsonProperty("metadata")
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public BearerAuthDefinition withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

}
