
package io.serverlessworkflow.api.auth;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;


/**
 * Auth Definition
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "name",
    "scheme",
    "basicauth",
    "bearerauth",
    "oauth"
})
public class AuthDefinition implements Serializable
{

    /**
     * Unique auth definition name
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("Unique auth definition name")
    @Size(min = 1)
    private String name;
    /**
     * Defines the auth type
     * 
     */
    @JsonProperty("scheme")
    @JsonPropertyDescription("Defines the auth type")
    private AuthDefinition.Scheme scheme = AuthDefinition.Scheme.fromValue("basic");
    @JsonProperty("basicauth")
    @Valid
    private BasicAuthDefinition basicauth;
    @JsonProperty("bearerauth")
    @Valid
    private BearerAuthDefinition bearerauth;
    @JsonProperty("oauth")
    @Valid
    private OauthDefinition oauth;
    private final static long serialVersionUID = 4557883378844963381L;

    /**
     * Unique auth definition name
     * 
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * Unique auth definition name
     * 
     */
    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public AuthDefinition withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Defines the auth type
     * 
     */
    @JsonProperty("scheme")
    public AuthDefinition.Scheme getScheme() {
        return scheme;
    }

    /**
     * Defines the auth type
     * 
     */
    @JsonProperty("scheme")
    public void setScheme(AuthDefinition.Scheme scheme) {
        this.scheme = scheme;
    }

    public AuthDefinition withScheme(AuthDefinition.Scheme scheme) {
        this.scheme = scheme;
        return this;
    }

    @JsonProperty("basicauth")
    public BasicAuthDefinition getBasicauth() {
        return basicauth;
    }

    @JsonProperty("basicauth")
    public void setBasicauth(BasicAuthDefinition basicauth) {
        this.basicauth = basicauth;
    }

    public AuthDefinition withBasicauth(BasicAuthDefinition basicauth) {
        this.basicauth = basicauth;
        return this;
    }

    @JsonProperty("bearerauth")
    public BearerAuthDefinition getBearerauth() {
        return bearerauth;
    }

    @JsonProperty("bearerauth")
    public void setBearerauth(BearerAuthDefinition bearerauth) {
        this.bearerauth = bearerauth;
    }

    public AuthDefinition withBearerauth(BearerAuthDefinition bearerauth) {
        this.bearerauth = bearerauth;
        return this;
    }

    @JsonProperty("oauth")
    public OauthDefinition getOauth() {
        return oauth;
    }

    @JsonProperty("oauth")
    public void setOauth(OauthDefinition oauth) {
        this.oauth = oauth;
    }

    public AuthDefinition withOauth(OauthDefinition oauth) {
        this.oauth = oauth;
        return this;
    }

    public enum Scheme {

        BASIC("basic"),
        BEARER("bearer"),
        OAUTH_2("oauth2");
        private final String value;
        private final static Map<String, AuthDefinition.Scheme> CONSTANTS = new HashMap<String, AuthDefinition.Scheme>();

        static {
            for (AuthDefinition.Scheme c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private Scheme(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static AuthDefinition.Scheme fromValue(String value) {
            AuthDefinition.Scheme constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
