
package io.serverlessworkflow.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.serverlessworkflow.api.datainputschema.DataInputSchema;
import io.serverlessworkflow.api.interfaces.Extension;
import io.serverlessworkflow.api.interfaces.State;
import io.serverlessworkflow.api.start.Start;
import io.serverlessworkflow.api.timeouts.TimeoutsDefinition;
import io.serverlessworkflow.api.workflow.Auth;
import io.serverlessworkflow.api.workflow.BaseWorkflow;
import io.serverlessworkflow.api.workflow.Constants;
import io.serverlessworkflow.api.workflow.Errors;
import io.serverlessworkflow.api.workflow.Events;
import io.serverlessworkflow.api.workflow.Functions;
import io.serverlessworkflow.api.workflow.Retries;
import io.serverlessworkflow.api.workflow.Secrets;


/**
 * Serverless Workflow is a vendor-neutral specification for defining the model of workflows responsible for orchestrating event-driven serverless applications.
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "id",
    "name",
    "description",
    "version",
    "annotations",
    "dataInputSchema",
    "start",
    "specVersion",
    "expressionLang",
    "keepActive",
    "autoRetries",
    "metadata",
    "events",
    "functions",
    "errors",
    "retries",
    "secrets",
    "constants",
    "timeouts",
    "auth",
    "states",
    "extensions"
})
public class Workflow
    extends BaseWorkflow
    implements Serializable
{

    /**
     * Workflow unique identifier
     * (Required)
     * 
     */
    @JsonProperty("id")
    @JsonPropertyDescription("Workflow unique identifier")
    @Size(min = 1)
    @NotNull
    private java.lang.String id;
    /**
     * Workflow name
     * (Required)
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("Workflow name")
    @Size(min = 1)
    @NotNull
    private java.lang.String name;
    /**
     * Workflow description
     * 
     */
    @JsonProperty("description")
    @JsonPropertyDescription("Workflow description")
    private java.lang.String description;
    /**
     * Workflow version
     * (Required)
     * 
     */
    @JsonProperty("version")
    @JsonPropertyDescription("Workflow version")
    @NotNull
    private java.lang.String version;
    /**
     * List of helpful terms describing the workflows intended purpose, subject areas, or other important qualities
     * 
     */
    @JsonProperty("annotations")
    @JsonPropertyDescription("List of helpful terms describing the workflows intended purpose, subject areas, or other important qualities")
    @Size(min = 1)
    @Valid
    private List<java.lang.String> annotations = new ArrayList<java.lang.String>();
    /**
     * Workflow data input schema
     * 
     */
    @JsonProperty("dataInputSchema")
    @JsonPropertyDescription("Workflow data input schema")
    @Valid
    private DataInputSchema dataInputSchema;
    /**
     * State start definition
     * 
     */
    @JsonProperty("start")
    @JsonPropertyDescription("State start definition")
    @Valid
    private Start start;
    /**
     * Serverless Workflow schema version
     * 
     */
    @JsonProperty("specVersion")
    @JsonPropertyDescription("Serverless Workflow schema version")
    private java.lang.String specVersion;
    /**
     * Identifies the expression language used for workflow expressions. Default is 'jq'
     * 
     */
    @JsonProperty("expressionLang")
    @JsonPropertyDescription("Identifies the expression language used for workflow expressions. Default is 'jq'")
    @Size(min = 1)
    private java.lang.String expressionLang = "jq";
    /**
     * If 'true', workflow instances is not terminated when there are no active execution paths. Instance can be terminated via 'terminate end definition' or reaching defined 'execTimeout'
     * 
     */
    @JsonProperty("keepActive")
    @JsonPropertyDescription("If 'true', workflow instances is not terminated when there are no active execution paths. Instance can be terminated via 'terminate end definition' or reaching defined 'execTimeout'")
    private boolean keepActive = false;
    /**
     * If set to true, actions should automatically be retried on unchecked errors. Default is false
     * 
     */
    @JsonProperty("autoRetries")
    @JsonPropertyDescription("If set to true, actions should automatically be retried on unchecked errors. Default is false")
    private boolean autoRetries = false;
    /**
     * Metadata
     * 
     */
    @JsonProperty("metadata")
    @JsonPropertyDescription("Metadata")
    @Valid
    private Map<String, String> metadata;
    /**
     * Workflow event definitions
     * 
     */
    @JsonProperty("events")
    @JsonPropertyDescription("Workflow event definitions")
    @Valid
    private Events events;
    /**
     * Workflow function definitions
     * 
     */
    @JsonProperty("functions")
    @JsonPropertyDescription("Workflow function definitions")
    @Valid
    private Functions functions;
    /**
     * Workflow error definitions
     * 
     */
    @JsonProperty("errors")
    @JsonPropertyDescription("Workflow error definitions")
    @Valid
    private Errors errors;
    /**
     * Workflow retry definitions
     * 
     */
    @JsonProperty("retries")
    @JsonPropertyDescription("Workflow retry definitions")
    @Valid
    private Retries retries;
    /**
     * Workflow secrets definitions
     * 
     */
    @JsonProperty("secrets")
    @JsonPropertyDescription("Workflow secrets definitions")
    @Valid
    private Secrets secrets;
    /**
     * Workflow constants definitions
     * 
     */
    @JsonProperty("constants")
    @JsonPropertyDescription("Workflow constants definitions")
    @Valid
    private Constants constants;
    /**
     * Timeouts Definition
     * 
     */
    @JsonProperty("timeouts")
    @JsonPropertyDescription("Timeouts Definition")
    @Valid
    private TimeoutsDefinition timeouts;
    /**
     * Workflow Auth definitions
     * 
     */
    @JsonProperty("auth")
    @JsonPropertyDescription("Workflow Auth definitions")
    @Valid
    private Auth auth;
    /**
     * State Definitions
     * (Required)
     * 
     */
    @JsonProperty("states")
    @JsonPropertyDescription("State Definitions")
    @Valid
    @NotNull
    private List<State> states = new ArrayList<State>();
    /**
     * Workflow Extensions
     * 
     */
    @JsonProperty("extensions")
    @JsonPropertyDescription("Workflow Extensions")
    @Valid
    private List<Extension> extensions = new ArrayList<Extension>();
    private final static long serialVersionUID = -8783529052335594182L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Workflow() {
    }

    /**
     * 
     * @param name
     * @param id
     * @param version
     * @param states
     */
    public Workflow(java.lang.String id, java.lang.String name, java.lang.String version, List<State> states) {
        super();
        this.id = id;
        this.name = name;
        this.version = version;
        this.states = states;
    }

    /**
     * Workflow unique identifier
     * (Required)
     * 
     */
    @JsonProperty("id")
    public java.lang.String getId() {
        return id;
    }

    /**
     * Workflow unique identifier
     * (Required)
     * 
     */
    @JsonProperty("id")
    public void setId(java.lang.String id) {
        this.id = id;
    }

    public Workflow withId(java.lang.String id) {
        this.id = id;
        return this;
    }

    /**
     * Workflow name
     * (Required)
     * 
     */
    @JsonProperty("name")
    public java.lang.String getName() {
        return name;
    }

    /**
     * Workflow name
     * (Required)
     * 
     */
    @JsonProperty("name")
    public void setName(java.lang.String name) {
        this.name = name;
    }

    public Workflow withName(java.lang.String name) {
        this.name = name;
        return this;
    }

    /**
     * Workflow description
     * 
     */
    @JsonProperty("description")
    public java.lang.String getDescription() {
        return description;
    }

    /**
     * Workflow description
     * 
     */
    @JsonProperty("description")
    public void setDescription(java.lang.String description) {
        this.description = description;
    }

    public Workflow withDescription(java.lang.String description) {
        this.description = description;
        return this;
    }

    /**
     * Workflow version
     * (Required)
     * 
     */
    @JsonProperty("version")
    public java.lang.String getVersion() {
        return version;
    }

    /**
     * Workflow version
     * (Required)
     * 
     */
    @JsonProperty("version")
    public void setVersion(java.lang.String version) {
        this.version = version;
    }

    public Workflow withVersion(java.lang.String version) {
        this.version = version;
        return this;
    }

    /**
     * List of helpful terms describing the workflows intended purpose, subject areas, or other important qualities
     * 
     */
    @JsonProperty("annotations")
    public List<java.lang.String> getAnnotations() {
        return annotations;
    }

    /**
     * List of helpful terms describing the workflows intended purpose, subject areas, or other important qualities
     * 
     */
    @JsonProperty("annotations")
    public void setAnnotations(List<java.lang.String> annotations) {
        this.annotations = annotations;
    }

    public Workflow withAnnotations(List<java.lang.String> annotations) {
        this.annotations = annotations;
        return this;
    }

    /**
     * Workflow data input schema
     * 
     */
    @JsonProperty("dataInputSchema")
    public DataInputSchema getDataInputSchema() {
        return dataInputSchema;
    }

    /**
     * Workflow data input schema
     * 
     */
    @JsonProperty("dataInputSchema")
    public void setDataInputSchema(DataInputSchema dataInputSchema) {
        this.dataInputSchema = dataInputSchema;
    }

    public Workflow withDataInputSchema(DataInputSchema dataInputSchema) {
        this.dataInputSchema = dataInputSchema;
        return this;
    }

    /**
     * State start definition
     * 
     */
    @JsonProperty("start")
    public Start getStart() {
        return start;
    }

    /**
     * State start definition
     * 
     */
    @JsonProperty("start")
    public void setStart(Start start) {
        this.start = start;
    }

    public Workflow withStart(Start start) {
        this.start = start;
        return this;
    }

    /**
     * Serverless Workflow schema version
     * 
     */
    @JsonProperty("specVersion")
    public java.lang.String getSpecVersion() {
        return specVersion;
    }

    /**
     * Serverless Workflow schema version
     * 
     */
    @JsonProperty("specVersion")
    public void setSpecVersion(java.lang.String specVersion) {
        this.specVersion = specVersion;
    }

    public Workflow withSpecVersion(java.lang.String specVersion) {
        this.specVersion = specVersion;
        return this;
    }

    /**
     * Identifies the expression language used for workflow expressions. Default is 'jq'
     * 
     */
    @JsonProperty("expressionLang")
    public java.lang.String getExpressionLang() {
        return expressionLang;
    }

    /**
     * Identifies the expression language used for workflow expressions. Default is 'jq'
     * 
     */
    @JsonProperty("expressionLang")
    public void setExpressionLang(java.lang.String expressionLang) {
        this.expressionLang = expressionLang;
    }

    public Workflow withExpressionLang(java.lang.String expressionLang) {
        this.expressionLang = expressionLang;
        return this;
    }

    /**
     * If 'true', workflow instances is not terminated when there are no active execution paths. Instance can be terminated via 'terminate end definition' or reaching defined 'execTimeout'
     * 
     */
    @JsonProperty("keepActive")
    public boolean isKeepActive() {
        return keepActive;
    }

    /**
     * If 'true', workflow instances is not terminated when there are no active execution paths. Instance can be terminated via 'terminate end definition' or reaching defined 'execTimeout'
     * 
     */
    @JsonProperty("keepActive")
    public void setKeepActive(boolean keepActive) {
        this.keepActive = keepActive;
    }

    public Workflow withKeepActive(boolean keepActive) {
        this.keepActive = keepActive;
        return this;
    }

    /**
     * If set to true, actions should automatically be retried on unchecked errors. Default is false
     * 
     */
    @JsonProperty("autoRetries")
    public boolean isAutoRetries() {
        return autoRetries;
    }

    /**
     * If set to true, actions should automatically be retried on unchecked errors. Default is false
     * 
     */
    @JsonProperty("autoRetries")
    public void setAutoRetries(boolean autoRetries) {
        this.autoRetries = autoRetries;
    }

    public Workflow withAutoRetries(boolean autoRetries) {
        this.autoRetries = autoRetries;
        return this;
    }

    /**
     * Metadata
     * 
     */
    @JsonProperty("metadata")
    public Map<String, String> getMetadata() {
        return metadata;
    }

    /**
     * Metadata
     * 
     */
    @JsonProperty("metadata")
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public Workflow withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    /**
     * Workflow event definitions
     * 
     */
    @JsonProperty("events")
    public Events getEvents() {
        return events;
    }

    /**
     * Workflow event definitions
     * 
     */
    @JsonProperty("events")
    public void setEvents(Events events) {
        this.events = events;
    }

    public Workflow withEvents(Events events) {
        this.events = events;
        return this;
    }

    /**
     * Workflow function definitions
     * 
     */
    @JsonProperty("functions")
    public Functions getFunctions() {
        return functions;
    }

    /**
     * Workflow function definitions
     * 
     */
    @JsonProperty("functions")
    public void setFunctions(Functions functions) {
        this.functions = functions;
    }

    public Workflow withFunctions(Functions functions) {
        this.functions = functions;
        return this;
    }

    /**
     * Workflow error definitions
     * 
     */
    @JsonProperty("errors")
    public Errors getErrors() {
        return errors;
    }

    /**
     * Workflow error definitions
     * 
     */
    @JsonProperty("errors")
    public void setErrors(Errors errors) {
        this.errors = errors;
    }

    public Workflow withErrors(Errors errors) {
        this.errors = errors;
        return this;
    }

    /**
     * Workflow retry definitions
     * 
     */
    @JsonProperty("retries")
    public Retries getRetries() {
        return retries;
    }

    /**
     * Workflow retry definitions
     * 
     */
    @JsonProperty("retries")
    public void setRetries(Retries retries) {
        this.retries = retries;
    }

    public Workflow withRetries(Retries retries) {
        this.retries = retries;
        return this;
    }

    /**
     * Workflow secrets definitions
     * 
     */
    @JsonProperty("secrets")
    public Secrets getSecrets() {
        return secrets;
    }

    /**
     * Workflow secrets definitions
     * 
     */
    @JsonProperty("secrets")
    public void setSecrets(Secrets secrets) {
        this.secrets = secrets;
    }

    public Workflow withSecrets(Secrets secrets) {
        this.secrets = secrets;
        return this;
    }

    /**
     * Workflow constants definitions
     * 
     */
    @JsonProperty("constants")
    public Constants getConstants() {
        return constants;
    }

    /**
     * Workflow constants definitions
     * 
     */
    @JsonProperty("constants")
    public void setConstants(Constants constants) {
        this.constants = constants;
    }

    public Workflow withConstants(Constants constants) {
        this.constants = constants;
        return this;
    }

    /**
     * Timeouts Definition
     * 
     */
    @JsonProperty("timeouts")
    public TimeoutsDefinition getTimeouts() {
        return timeouts;
    }

    /**
     * Timeouts Definition
     * 
     */
    @JsonProperty("timeouts")
    public void setTimeouts(TimeoutsDefinition timeouts) {
        this.timeouts = timeouts;
    }

    public Workflow withTimeouts(TimeoutsDefinition timeouts) {
        this.timeouts = timeouts;
        return this;
    }

    /**
     * Workflow Auth definitions
     * 
     */
    @JsonProperty("auth")
    public Auth getAuth() {
        return auth;
    }

    /**
     * Workflow Auth definitions
     * 
     */
    @JsonProperty("auth")
    public void setAuth(Auth auth) {
        this.auth = auth;
    }

    public Workflow withAuth(Auth auth) {
        this.auth = auth;
        return this;
    }

    /**
     * State Definitions
     * (Required)
     * 
     */
    @JsonProperty("states")
    public List<State> getStates() {
        return states;
    }

    /**
     * State Definitions
     * (Required)
     * 
     */
    @JsonProperty("states")
    public void setStates(List<State> states) {
        this.states = states;
    }

    public Workflow withStates(List<State> states) {
        this.states = states;
        return this;
    }

    /**
     * Workflow Extensions
     * 
     */
    @JsonProperty("extensions")
    public List<Extension> getExtensions() {
        return extensions;
    }

    /**
     * Workflow Extensions
     * 
     */
    @JsonProperty("extensions")
    public void setExtensions(List<Extension> extensions) {
        this.extensions = extensions;
    }

    public Workflow withExtensions(List<Extension> extensions) {
        this.extensions = extensions;
        return this;
    }

}
