/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.jakarta.webflux;

import io.sentry.IHub;
import io.sentry.Sentry;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public final class SentryScheduleHook
implements Function<Runnable, Runnable> {
    @Override
    public Runnable apply(@NotNull Runnable runnable) {
        IHub newHub = Sentry.getCurrentHub().clone();
        return () -> {
            IHub oldState = Sentry.getCurrentHub();
            Sentry.setCurrentHub((IHub)newHub);
            try {
                runnable.run();
            }
            finally {
                Sentry.setCurrentHub((IHub)oldState);
            }
        };
    }
}

