/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.undo.mysql;

import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.rm.datasource.sql.struct.Field;
import io.seata.rm.datasource.sql.struct.Row;
import io.seata.rm.datasource.sql.struct.TableRecords;
import io.seata.rm.datasource.undo.AbstractUndoExecutor;
import io.seata.rm.datasource.undo.KeywordChecker;
import io.seata.rm.datasource.undo.KeywordCheckerFactory;
import io.seata.rm.datasource.undo.SQLUndoLog;
import java.util.List;
import java.util.stream.Collectors;

public class MySQLUndoUpdateExecutor
extends AbstractUndoExecutor {
    private static final String UPDATE_SQL_TEMPLATE = "UPDATE %s SET %s WHERE %s = ?";

    @Override
    protected String buildUndoSQL() {
        KeywordChecker keywordChecker = KeywordCheckerFactory.getKeywordChecker("mysql");
        TableRecords beforeImage = this.sqlUndoLog.getBeforeImage();
        List<Row> beforeImageRows = beforeImage.getRows();
        if (beforeImageRows == null || beforeImageRows.size() == 0) {
            throw new ShouldNeverHappenException("Invalid UNDO LOG");
        }
        Row row = beforeImageRows.get(0);
        Field pkField = row.primaryKeys().get(0);
        List<Field> nonPkFields = row.nonPrimaryKeys();
        String updateColumns = nonPkFields.stream().map(field -> keywordChecker.checkAndReplace(field.getName()) + " = ?").collect(Collectors.joining(", "));
        return String.format(UPDATE_SQL_TEMPLATE, keywordChecker.checkAndReplace(this.sqlUndoLog.getTableName()), updateColumns, keywordChecker.checkAndReplace(pkField.getName()));
    }

    public MySQLUndoUpdateExecutor(SQLUndoLog sqlUndoLog) {
        super(sqlUndoLog);
    }

    @Override
    protected TableRecords getUndoRows() {
        return this.sqlUndoLog.getBeforeImage();
    }
}

