/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.micrometer;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.rsocket.Payload;
import io.rsocket.RSocket;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;

final class MicrometerRSocket
implements RSocket {
    private final RSocket delegate;
    private final InteractionCounters metadataPush;
    private final InteractionCounters requestChannel;
    private final InteractionCounters requestFireAndForget;
    private final InteractionTimers requestResponse;
    private final InteractionCounters requestStream;

    MicrometerRSocket(RSocket delegate, MeterRegistry meterRegistry, Tag ... tags) {
        this.delegate = Objects.requireNonNull(delegate, "delegate must not be null");
        Objects.requireNonNull(meterRegistry, "meterRegistry must not be null");
        this.metadataPush = new InteractionCounters(meterRegistry, "metadata.push", tags);
        this.requestChannel = new InteractionCounters(meterRegistry, "request.channel", tags);
        this.requestFireAndForget = new InteractionCounters(meterRegistry, "request.fnf", tags);
        this.requestResponse = new InteractionTimers(meterRegistry, "request.response", tags);
        this.requestStream = new InteractionCounters(meterRegistry, "request.stream", tags);
    }

    public void dispose() {
        this.delegate.dispose();
    }

    public Mono<Void> fireAndForget(Payload payload) {
        return this.delegate.fireAndForget(payload).doFinally((Consumer)this.requestFireAndForget);
    }

    public Mono<Void> metadataPush(Payload payload) {
        return this.delegate.metadataPush(payload).doFinally((Consumer)this.metadataPush);
    }

    public Mono<Void> onClose() {
        return this.delegate.onClose();
    }

    public Flux<Payload> requestChannel(Publisher<Payload> payloads) {
        return this.delegate.requestChannel(payloads).doFinally((Consumer)this.requestChannel);
    }

    public Mono<Payload> requestResponse(Payload payload) {
        return Mono.defer(() -> {
            Timer.Sample sample = this.requestResponse.start();
            return this.delegate.requestResponse(payload).doFinally(signalType -> this.requestResponse.accept(sample, (SignalType)signalType));
        });
    }

    public Flux<Payload> requestStream(Payload payload) {
        return this.delegate.requestStream(payload).doFinally((Consumer)this.requestStream);
    }

    private static final class InteractionTimers
    implements BiConsumer<Timer.Sample, SignalType> {
        private final Timer cancel;
        private final MeterRegistry meterRegistry;
        private final Timer onComplete;
        private final Timer onError;

        private InteractionTimers(MeterRegistry meterRegistry, String interactionModel, Tag ... tags) {
            this.meterRegistry = meterRegistry;
            this.cancel = InteractionTimers.timer(meterRegistry, interactionModel, SignalType.CANCEL, tags);
            this.onComplete = InteractionTimers.timer(meterRegistry, interactionModel, SignalType.ON_COMPLETE, tags);
            this.onError = InteractionTimers.timer(meterRegistry, interactionModel, SignalType.ON_ERROR, tags);
        }

        @Override
        public void accept(Timer.Sample sample, SignalType signalType) {
            switch (signalType) {
                case CANCEL: {
                    sample.stop(this.cancel);
                    break;
                }
                case ON_COMPLETE: {
                    sample.stop(this.onComplete);
                    break;
                }
                case ON_ERROR: {
                    sample.stop(this.onError);
                }
            }
        }

        Timer.Sample start() {
            return Timer.start((MeterRegistry)this.meterRegistry);
        }

        private static Timer timer(MeterRegistry meterRegistry, String interactionModel, SignalType signalType, Tag ... tags) {
            return meterRegistry.timer("rsocket." + interactionModel, (Iterable)Tags.of((Tag[])tags).and("signal.type", signalType.name()));
        }
    }

    private static final class InteractionCounters
    implements Consumer<SignalType> {
        private final Counter cancel;
        private final Counter onComplete;
        private final Counter onError;

        private InteractionCounters(MeterRegistry meterRegistry, String interactionModel, Tag ... tags) {
            this.cancel = InteractionCounters.counter(meterRegistry, interactionModel, SignalType.CANCEL, tags);
            this.onComplete = InteractionCounters.counter(meterRegistry, interactionModel, SignalType.ON_COMPLETE, tags);
            this.onError = InteractionCounters.counter(meterRegistry, interactionModel, SignalType.ON_ERROR, tags);
        }

        @Override
        public void accept(SignalType signalType) {
            switch (signalType) {
                case CANCEL: {
                    this.cancel.increment();
                    break;
                }
                case ON_COMPLETE: {
                    this.onComplete.increment();
                    break;
                }
                case ON_ERROR: {
                    this.onError.increment();
                }
            }
        }

        private static Counter counter(MeterRegistry meterRegistry, String interactionModel, SignalType signalType, Tag ... tags) {
            return meterRegistry.counter("rsocket." + interactionModel, (Iterable)Tags.of((Tag[])tags).and("signal.type", signalType.name()));
        }
    }
}

