/*
 * Decompiled with CFR 0.152.
 */
package restx.stats;

import com.google.common.base.Optional;
import com.google.common.base.Stopwatch;
import java.io.IOException;
import restx.RestxContext;
import restx.RestxHandler;
import restx.RestxHandlerMatch;
import restx.RestxRequest;
import restx.RestxRequestMatch;
import restx.RestxResponse;
import restx.RestxRoute;
import restx.RestxRouteFilter;
import restx.StdRestxRequestMatch;
import restx.factory.Component;
import restx.stats.RestxStatsCollector;

@Component(priority=-1000)
public final class RestxStatsCollectionFilter
implements RestxRouteFilter,
RestxHandler {
    private final RestxStatsCollector collector;

    public RestxStatsCollectionFilter(RestxStatsCollector collector) {
        this.collector = collector;
    }

    public Optional<RestxHandlerMatch> match(RestxRoute route) {
        return Optional.of((Object)new RestxHandlerMatch((RestxRequestMatch)new StdRestxRequestMatch("/*"), (RestxHandler)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(RestxRequestMatch match, RestxRequest req, RestxResponse resp, RestxContext ctx) throws IOException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            ctx.nextHandlerMatch().handle(req, resp, ctx);
        }
        finally {
            this.collector.notifyRequest(req, resp, stopwatch.stop());
        }
    }

    public String toString() {
        return "RestxStatsFiler";
    }
}

