/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.impl;

import io.vertx.core.buffer.Buffer;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.WriterInterceptor;
import jakarta.ws.rs.ext.WriterInterceptorContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.jboss.resteasy.reactive.client.impl.AbstractClientInterceptorContextImpl;
import org.jboss.resteasy.reactive.client.impl.RestClientRequestContext;
import org.jboss.resteasy.reactive.client.spi.ClientMessageBodyWriter;
import org.jboss.resteasy.reactive.common.core.Serialisers;
import org.jboss.resteasy.reactive.common.jaxrs.ConfigurationImpl;

public class ClientWriterInterceptorContextImpl
extends AbstractClientInterceptorContextImpl
implements WriterInterceptorContext {
    private final ByteArrayOutputStream baos = new ByteArrayOutputStream();
    boolean done = false;
    private int index = 0;
    private OutputStream outputStream = this.baos;
    private final RestClientRequestContext clientRequestContext;
    private final Serialisers serialisers;
    private final ConfigurationImpl configuration;
    protected boolean rediscoveryNeeded = false;
    private MultivaluedMap<String, String> headers;
    private Object entity;
    private MessageBodyWriter writer;
    private WriterInterceptor[] interceptors;
    private Buffer result;

    public ClientWriterInterceptorContextImpl(WriterInterceptor[] writerInterceptors, MessageBodyWriter writer, Annotation[] annotations, Class<?> entityClass, Type entityType, Object entity, MediaType mediaType, MultivaluedMap<String, String> headers, Map<String, Object> properties, RestClientRequestContext clientRequestContext, Serialisers serialisers, ConfigurationImpl configuration) {
        super(annotations, entityClass, entityType, mediaType, properties);
        this.clientRequestContext = clientRequestContext;
        this.interceptors = writerInterceptors;
        this.writer = writer;
        this.entity = entity;
        this.headers = headers;
        this.serialisers = serialisers;
        this.configuration = configuration;
    }

    public void proceed() throws IOException, WebApplicationException {
        if (this.index == this.interceptors.length) {
            MessageBodyWriter effectiveWriter = this.writer;
            if (this.rediscoveryNeeded) {
                List newWriters = this.serialisers.findWriters(this.configuration, this.entityClass, this.mediaType, RuntimeType.CLIENT);
                if (newWriters.isEmpty()) {
                    return;
                }
                effectiveWriter = (MessageBodyWriter)newWriters.get(0);
            }
            if (effectiveWriter instanceof ClientMessageBodyWriter) {
                ClientMessageBodyWriter cw = (ClientMessageBodyWriter)effectiveWriter;
                cw.writeTo(this.entity, this.entityClass, this.entityType, this.annotations, this.mediaType, this.headers, this.outputStream, this.clientRequestContext);
            } else {
                effectiveWriter.writeTo(this.entity, this.entityClass, this.entityType, this.annotations, this.mediaType, this.headers, this.outputStream);
            }
            this.outputStream.close();
            this.result = Buffer.buffer((byte[])this.baos.toByteArray());
            this.done = true;
        } else {
            this.interceptors[this.index++].aroundWriteTo((WriterInterceptorContext)this);
        }
    }

    public Object getEntity() {
        return this.entity;
    }

    public void setEntity(Object entity) {
        this.entity = entity;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream os) {
        this.outputStream = os;
    }

    public MultivaluedMap<String, Object> getHeaders() {
        return this.headers;
    }

    public Buffer getResult() {
        return this.result;
    }

    @Override
    public void setType(Class<?> type) {
        if (this.entityClass != type && type != null) {
            this.rediscoveryNeeded = true;
        }
        this.entityClass = type;
    }

    @Override
    public void setMediaType(MediaType mediaType) {
        if (this.mediaType != mediaType) {
            this.rediscoveryNeeded = true;
        }
        this.mediaType = mediaType;
    }
}

