/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.CompletedStage;
import io.quarkus.qute.Expression;
import io.quarkus.qute.Expressions;
import io.quarkus.qute.LiteralSupport;
import io.quarkus.qute.Parser;
import io.quarkus.qute.Results;
import io.quarkus.qute.Scope;
import io.quarkus.qute.TemplateNode;
import io.quarkus.qute.ValueResolver;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

final class ExpressionImpl
implements Expression {
    static final ExpressionImpl EMPTY = new ExpressionImpl(0, null, Collections.emptyList(), Results.NotFound.EMPTY, null);
    private final int id;
    private final String namespace;
    private final List<Expression.Part> parts;
    private final CompletedStage<Object> literal;
    private final TemplateNode.Origin origin;

    static ExpressionImpl from(String value) {
        if (value == null || value.isEmpty()) {
            return EMPTY;
        }
        return Parser.parseExpression(ExpressionImpl::syntheticId, value, Scope.EMPTY, Parser.SYNTHETIC_ORIGIN);
    }

    static ExpressionImpl literalFrom(int id, String literal) {
        if (literal == null || literal.isEmpty()) {
            return EMPTY;
        }
        Object literalValue = LiteralSupport.getLiteralValue(literal);
        return ExpressionImpl.literal(id, literal, literalValue, Parser.SYNTHETIC_ORIGIN);
    }

    static ExpressionImpl literal(int id, String literal, Object value, TemplateNode.Origin origin) {
        if (literal == null) {
            throw new IllegalArgumentException("Literal must not be null");
        }
        String typeInfo = null;
        if (value != null) {
            typeInfo = Expressions.typeInfoFrom(value.getClass().getName());
        }
        return new ExpressionImpl(id, null, List.of(new PartImpl(literal, typeInfo)), value, origin);
    }

    static Integer syntheticId() {
        return -1;
    }

    ExpressionImpl(int id, String namespace, List<Expression.Part> parts, Object literal, TemplateNode.Origin origin) {
        this.id = id;
        this.namespace = namespace;
        this.parts = parts;
        this.literal = literal != Results.NotFound.EMPTY ? CompletedStage.of(literal) : null;
        this.origin = origin;
    }

    @Override
    public boolean hasNamespace() {
        return this.namespace != null;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public List<Expression.Part> getParts() {
        return this.parts;
    }

    @Override
    public boolean isLiteral() {
        return this.literal != null;
    }

    @Override
    public CompletableFuture<Object> getLiteralValue() {
        return this.literal != null ? this.literal.toCompletableFuture() : null;
    }

    @Override
    public Object getLiteral() {
        return this.literal != null ? this.literal.get() : null;
    }

    @Override
    public CompletionStage<Object> asLiteral() {
        if (this.literal == null) {
            throw new IllegalStateException("Expression is not a literal: " + this.toString());
        }
        return this.literal;
    }

    @Override
    public TemplateNode.Origin getOrigin() {
        return this.origin;
    }

    @Override
    public int getGeneratedId() {
        return this.id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this.toOriginalString());
        result = 31 * result + Objects.hashCode(this.origin);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExpressionImpl other = (ExpressionImpl)obj;
        return Objects.equals(this.toOriginalString(), other.toOriginalString()) && Objects.equals(this.origin, other.origin);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Expression [namespace=").append(this.namespace).append(", parts=").append(this.parts).append(", literal=").append(this.literalValue()).append("]");
        return builder.toString();
    }

    @Override
    public String toOriginalString() {
        StringBuilder builder = new StringBuilder();
        if (this.namespace != null) {
            builder.append(this.namespace);
            builder.append(":");
        }
        Iterator<Expression.Part> iterator = this.parts.iterator();
        while (iterator.hasNext()) {
            builder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            builder.append(".");
        }
        return builder.toString();
    }

    private Object literalValue() {
        if (this.literal != null) {
            return this.literal.get();
        }
        return null;
    }

    static class PartImpl
    implements Expression.Part {
        protected final String name;
        protected final String typeInfo;
        protected volatile ValueResolver cachedResolver;

        PartImpl(String name, String typeInfo) {
            this.name = name;
            this.typeInfo = typeInfo;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getTypeInfo() {
            return this.typeInfo;
        }

        public int hashCode() {
            return Objects.hash(this.name, this.typeInfo);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PartImpl other = (PartImpl)obj;
            return Objects.equals(this.name, other.name) && Objects.equals(this.typeInfo, other.typeInfo);
        }

        public String toString() {
            return this.name;
        }
    }

    static class VirtualMethodPartImpl
    extends PartImpl
    implements Expression.VirtualMethodPart {
        private final List<Expression> parameters;

        VirtualMethodPartImpl(String name, List<Expression> parameters, String lastPartHint) {
            super(name, VirtualMethodPartImpl.buildTypeInfo(name, parameters, lastPartHint));
            this.parameters = parameters;
        }

        @Override
        public List<Expression> getParameters() {
            return this.parameters;
        }

        @Override
        public boolean isVirtualMethod() {
            return true;
        }

        @Override
        public Expression.VirtualMethodPart asVirtualMethod() {
            return this;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + Objects.hash(this.parameters);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            VirtualMethodPartImpl other = (VirtualMethodPartImpl)obj;
            return Objects.equals(this.parameters, other.parameters);
        }

        @Override
        public String toString() {
            return VirtualMethodPartImpl.buildTypeInfo(this.name, this.parameters, null);
        }

        private static String buildTypeInfo(String name, List<Expression> parameters, String lastPartHint) {
            StringBuilder builder = new StringBuilder();
            builder.append(name).append("(");
            Iterator<Expression> iterator = parameters.iterator();
            while (iterator.hasNext()) {
                Expression expression = iterator.next();
                builder.append(expression.toOriginalString());
                if (!iterator.hasNext()) continue;
                builder.append(",");
            }
            builder.append(")");
            if (lastPartHint != null) {
                builder.append(lastPartHint);
            }
            return builder.toString();
        }
    }
}

