/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.EngineBuilder;
import io.quarkus.qute.ErrorInitializer;
import io.quarkus.qute.Evaluator;
import io.quarkus.qute.Expression;
import io.quarkus.qute.NamespaceResolver;
import io.quarkus.qute.ResultMapper;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.Template;
import io.quarkus.qute.TemplateInstance;
import io.quarkus.qute.TemplateLocator;
import io.quarkus.qute.TraceManager;
import io.quarkus.qute.ValueResolver;
import io.quarkus.qute.Variant;
import io.quarkus.qute.trace.TraceListener;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;

public interface Engine
extends ErrorInitializer {
    public static EngineBuilder builder() {
        return new EngineBuilder();
    }

    default public Template parse(String content) {
        return this.parse(content, null, null);
    }

    default public Template parse(String content, Variant variant) {
        return this.parse(content, variant, null);
    }

    public Template parse(String var1, Variant var2, String var3);

    public List<ResultMapper> getResultMappers();

    public String mapResult(Object var1, Expression var2);

    public Template putTemplate(String var1, Template var2);

    public Template getTemplate(String var1);

    public boolean isTemplateLoaded(String var1);

    public void clearTemplates();

    public void removeTemplates(Predicate<String> var1);

    public SectionHelperFactory<?> getSectionHelperFactory(String var1);

    public Map<String, SectionHelperFactory<?>> getSectionHelperFactories();

    public List<ValueResolver> getValueResolvers();

    public List<NamespaceResolver> getNamespaceResolvers();

    public Evaluator getEvaluator();

    public List<TemplateInstance.Initializer> getTemplateInstanceInitializers();

    public long getTimeout();

    public boolean useAsyncTimeout();

    public Optional<TemplateLocator.TemplateLocation> locate(String var1);

    public boolean removeStandaloneLines();

    public TraceManager getTraceManager();

    default public void addTraceListener(TraceListener listener) {
        TraceManager manager = this.getTraceManager();
        if (manager == null) {
            throw new IllegalStateException("Tracing not enabled");
        }
        manager.addTraceListener(listener);
    }

    default public void removeTraceListener(TraceListener listener) {
        TraceManager manager = this.getTraceManager();
        if (manager == null) {
            throw new IllegalStateException("Tracing not enabled");
        }
        manager.removeTraceListener(listener);
    }

    public EngineBuilder newBuilder();
}

