/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.Expression;
import io.quarkus.qute.ExpressionNode;
import io.quarkus.qute.ParameterDeclaration;
import io.quarkus.qute.ParameterDeclarationNode;
import io.quarkus.qute.ResolutionContext;
import io.quarkus.qute.ResultNode;
import io.quarkus.qute.SectionNode;
import io.quarkus.qute.TextNode;
import io.quarkus.qute.Variant;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletionStage;

public interface TemplateNode {
    public CompletionStage<ResultNode> resolve(ResolutionContext var1);

    default public List<Expression> getExpressions() {
        return Collections.emptyList();
    }

    default public List<ParameterDeclaration> getParameterDeclarations() {
        return Collections.emptyList();
    }

    public Origin getOrigin();

    default public boolean isConstant() {
        return false;
    }

    default public boolean isSection() {
        return this.kind() == Kind.SECTION;
    }

    default public boolean isText() {
        return this.kind() == Kind.TEXT;
    }

    default public boolean isExpression() {
        return this.kind() == Kind.EXPRESSION;
    }

    public Kind kind();

    default public TextNode asText() {
        throw new IllegalStateException();
    }

    default public SectionNode asSection() {
        throw new IllegalStateException();
    }

    default public ExpressionNode asExpression() {
        throw new IllegalStateException();
    }

    default public ParameterDeclarationNode asParamDeclaration() {
        throw new IllegalStateException();
    }

    public static enum Kind {
        TEXT,
        SECTION,
        EXPRESSION,
        PARAM_DECLARATION;

    }

    public static interface Origin {
        public int getLine();

        public int getLineCharacterStart();

        public int getLineCharacterEnd();

        public String getTemplateId();

        public String getTemplateGeneratedId();

        default public boolean hasNonGeneratedTemplateId() {
            return !this.getTemplateId().equals(this.getTemplateGeneratedId());
        }

        public Optional<Variant> getVariant();

        default public void appendTo(StringBuilder builder) {
            if (this.hasNonGeneratedTemplateId()) {
                builder.append(" template [").append(this.getTemplateId()).append(":").append(this.getLine()).append("]");
            }
        }

        default public boolean isSynthetic() {
            return this.getLine() == -1;
        }
    }
}

