/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.Engine;
import io.quarkus.qute.ErrorCode;
import io.quarkus.qute.Expression;
import io.quarkus.qute.Expressions;
import io.quarkus.qute.FragmentSectionHelper;
import io.quarkus.qute.ImmutableList;
import io.quarkus.qute.LiteralSupport;
import io.quarkus.qute.Mapper;
import io.quarkus.qute.Parameter;
import io.quarkus.qute.ResolutionContext;
import io.quarkus.qute.ResultNode;
import io.quarkus.qute.Scope;
import io.quarkus.qute.SectionBlock;
import io.quarkus.qute.SectionHelper;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.SectionNode;
import io.quarkus.qute.Template;
import io.quarkus.qute.TemplateNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;

public class IncludeSectionHelper
implements SectionHelper {
    static final String DEFAULT_NAME = "$default$";
    private static final String TEMPLATE = "template";
    private static final Map<String, Object> FRAGMENT_PARAMS = Map.of("qute$fragment", true);
    protected final TemplateSupplier templateSupplier;
    protected final Map<String, SectionBlock> extendingBlocks;
    protected final Map<String, Expression> parameters;
    protected final boolean isIsolated;

    IncludeSectionHelper(TemplateSupplier templateSupplier, Map<String, SectionBlock> extendingBlocks, Map<String, Expression> parameters, boolean isIsolated) {
        this.templateSupplier = templateSupplier;
        this.extendingBlocks = extendingBlocks;
        this.parameters = parameters;
        this.isIsolated = isIsolated;
    }

    @Override
    public CompletionStage<ResultNode> resolve(SectionHelper.SectionResolutionContext context) {
        if (this.parameters.isEmpty() && this.optimizeIfNoParams()) {
            Template template = this.templateSupplier.get(Map.of());
            SectionNode root = template.getRootNode();
            ResolutionContext resolutionContext = this.isIsolated ? context.newResolutionContext(null, this.extendingBlocks) : (this.extendingBlocks.isEmpty() ? context.resolutionContext() : context.resolutionContext().createChild(null, this.extendingBlocks));
            return root.resolve(resolutionContext, template.isFragment() ? FRAGMENT_PARAMS : null);
        }
        CompletableFuture<ResultNode> result = new CompletableFuture<ResultNode>();
        context.evaluate(this.parameters).whenComplete((evaluatedParams, t1) -> {
            if (t1 != null) {
                result.completeExceptionally((Throwable)t1);
            } else {
                this.addAdditionalEvaluatedParams(context, (Map<String, Object>)evaluatedParams);
                try {
                    Mapper data = Mapper.wrap(evaluatedParams);
                    ResolutionContext resolutionContext = this.isIsolated ? context.newResolutionContext(data, this.extendingBlocks) : context.resolutionContext().createChild(data, this.extendingBlocks);
                    Template template = this.templateSupplier.get((Map<String, Object>)evaluatedParams);
                    SectionNode root = template.getRootNode();
                    root.resolve(resolutionContext, template.isFragment() ? FRAGMENT_PARAMS : null).whenComplete((resultNode, t2) -> {
                        if (t2 != null) {
                            result.completeExceptionally((Throwable)t2);
                        } else {
                            result.complete((ResultNode)resultNode);
                        }
                    });
                }
                catch (Throwable e) {
                    result.completeExceptionally(e);
                }
            }
        });
        return result;
    }

    public Map<String, Expression> getParameters() {
        return this.parameters;
    }

    public boolean isIsolated() {
        return this.isIsolated;
    }

    protected boolean optimizeIfNoParams() {
        return true;
    }

    protected void addAdditionalEvaluatedParams(SectionHelper.SectionResolutionContext context, Map<String, Object> evaluatedParams) {
    }

    static abstract class TemplateSupplier {
        protected final Engine engine;
        protected final TemplateNode.Origin origin;
        protected final boolean ignoreFragments;

        TemplateSupplier(SectionHelperFactory.SectionInitContext context, boolean ignoreFragments) {
            this.engine = context.getEngine();
            this.origin = context.getOrigin();
            this.ignoreFragments = ignoreFragments ? true : Boolean.parseBoolean(context.getParameterOrDefault("_ignoreFragments", "false"));
        }

        abstract Template get(Map<String, Object> var1);

        protected Template doGet(String templateId, String fragmentId, Supplier<Template> currentTemplate) {
            Template ret = currentTemplate != null ? currentTemplate.get() : this.engine.getTemplate(templateId);
            if (ret == null) {
                throw this.engine.error("included template [{templateId}] not found").code(Code.TEMPLATE_NOT_FOUND).argument("templateId", templateId).origin(this.origin).build();
            }
            if (fragmentId != null) {
                Template.Fragment fragment = ret.getFragment(fragmentId);
                if (fragment == null) {
                    throw this.engine.error("fragment [{fragmentId}] not found in the included template [{templateId}]").code(Code.FRAGMENT_NOT_FOUND).argument("templateId", templateId).argument("fragmentId", fragmentId).origin(this.origin).build();
                }
                ret = fragment;
            }
            return ret;
        }

        protected String getFragmentId(String templateId) {
            if (this.ignoreFragments) {
                return null;
            }
            int idx = templateId.lastIndexOf(36);
            if (idx != -1) {
                String fragmentId = templateId.substring(idx + 1, templateId.length());
                if (FragmentSectionHelper.Factory.FRAGMENT_PATTERN.matcher(fragmentId).matches()) {
                    return fragmentId;
                }
                throw this.engine.error("invalid fragment identifier [{fragmentId}]").code(Code.INVALID_FRAGMENT_ID).argument("fragmentId", fragmentId).origin(this.origin).build();
            }
            return null;
        }
    }

    static class DynamicTemplateSupplier
    extends TemplateSupplier {
        private final Supplier<Template> currentTemplate;

        DynamicTemplateSupplier(SectionHelperFactory.SectionInitContext context, boolean ignoreFragments) {
            super(context, ignoreFragments);
            this.currentTemplate = context.getCurrentTemplate();
        }

        @Override
        Template get(Map<String, Object> params) {
            Object templateIdVal = params.get("_id");
            if (templateIdVal == null) {
                throw this.engine.error("dynamically included template not found").code(Code.TEMPLATE_NOT_FOUND).origin(this.origin).build();
            }
            String templateId = templateIdVal.toString();
            String fragmentId = this.getFragmentId(templateId);
            Supplier<Template> currentTemplate = fragmentId != null ? ((templateId = templateId.substring(0, templateId.lastIndexOf(36))).isEmpty() ? this.currentTemplate : null) : null;
            return this.doGet(templateId, fragmentId, currentTemplate);
        }
    }

    static class FixedTemplateSupplier
    extends TemplateSupplier {
        private final String templateId;
        private final String fragmentId;
        private final Supplier<Template> currentTemplate;

        FixedTemplateSupplier(SectionHelperFactory.SectionInitContext context, boolean ignoreFragments, String templateId) {
            super(context, ignoreFragments);
            String fragmentId = this.getFragmentId(templateId);
            Supplier<Template> currentTemplate = fragmentId != null ? ((templateId = templateId.substring(0, templateId.lastIndexOf(36))).isEmpty() ? context.getCurrentTemplate() : null) : null;
            this.templateId = templateId;
            this.fragmentId = fragmentId;
            this.currentTemplate = currentTemplate;
        }

        @Override
        Template get(Map<String, Object> params) {
            return this.doGet(this.templateId, this.fragmentId, this.currentTemplate);
        }
    }

    static enum Code implements ErrorCode
    {
        MULTIPLE_INSERTS_OF_NAME,
        TEMPLATE_NOT_FOUND,
        FRAGMENT_NOT_FOUND,
        INVALID_FRAGMENT_ID;


        @Override
        public String getName() {
            return "INCLUDE_" + this.name();
        }
    }

    static abstract class AbstractIncludeFactory<T extends SectionHelper>
    implements SectionHelperFactory<T> {
        static final String ISOLATED = "_isolated";
        static final String UNISOLATED = "_unisolated";
        static final String IGNORE_FRAGMENTS = "_ignoreFragments";
        static final Pattern WHITESPACE = Pattern.compile("\\s");

        AbstractIncludeFactory() {
        }

        @Override
        public boolean treatUnknownSectionsAsBlocks() {
            return true;
        }

        String isolatedDefaultValue() {
            return Boolean.FALSE.toString();
        }

        void addDefaultParams(SectionHelperFactory.ParametersInfo.Builder builder) {
            builder.addParameter(Parameter.builder(ISOLATED).defaultValue(this.isolatedDefaultValue()).optional().valuePredicate(ISOLATED::equals).build()).addParameter(Parameter.builder(UNISOLATED).optional().valuePredicate(UNISOLATED::equals).build()).addParameter(Parameter.builder(IGNORE_FRAGMENTS).defaultValue(Boolean.FALSE.toString()).optional().valuePredicate(IGNORE_FRAGMENTS::equals).build()).build();
        }

        protected boolean skipBuiltInParam(String value) {
            return value != null && !value.startsWith("_");
        }

        @Override
        public Scope initializeBlock(Scope outerScope, SectionHelperFactory.BlockInfo block) {
            if (block.getLabel().equals("$main")) {
                Map<String, String> params = block.getParameters();
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    this.processParam(params, key, value, () -> block.getParameter(0), (k, v) -> block.addExpression((String)k, (String)v));
                }
                return outerScope;
            }
            return outerScope;
        }

        @Override
        public T initialize(SectionHelperFactory.SectionInitContext context) {
            Map<String, SectionBlock> extendingBlocks;
            boolean isEmpty = context.getBlocks().size() == 1 && context.getBlocks().get(0).isEmpty();
            Boolean isolatedValue = null;
            boolean ignoreFragments = false;
            if (isEmpty) {
                extendingBlocks = Map.of();
            } else {
                extendingBlocks = new HashMap();
                for (SectionBlock block : context.getBlocks()) {
                    String name = block.id.equals("$main") ? IncludeSectionHelper.DEFAULT_NAME : block.label;
                    if (extendingBlocks.put(name, block) == null) continue;
                    throw block.error("multiple blocks define the content for the \\{#insert\\} section of name [{name}]").code(Code.MULTIPLE_INSERTS_OF_NAME).origin(context.getOrigin()).argument("name", name).build();
                }
            }
            HashMap<String, Expression> params = new HashMap<String, Expression>();
            Map<String, String> contextParams = context.getParameters();
            for (Map.Entry<String, String> entry : contextParams.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (value.equals(ISOLATED)) {
                    isolatedValue = true;
                    continue;
                }
                if (value.equals(UNISOLATED)) {
                    isolatedValue = false;
                    continue;
                }
                if (value.equals(IGNORE_FRAGMENTS)) {
                    ignoreFragments = true;
                    continue;
                }
                this.processParam(contextParams, key, value, () -> context.getParameter(0), (k, v) -> params.put((String)k, context.getExpression((String)k)));
            }
            String templateId = this.getTemplateId(context);
            TemplateSupplier templateSupplier = templateId != null ? new FixedTemplateSupplier(context, ignoreFragments, templateId) : new DynamicTemplateSupplier(context, ignoreFragments);
            return this.newHelper(templateSupplier, params, extendingBlocks, isolatedValue, context);
        }

        protected abstract String getTemplateId(SectionHelperFactory.SectionInitContext var1);

        protected void processParam(Map<String, String> params, String key, String value, Supplier<String> firstParamValue, BiConsumer<String, String> paramConsumer) {
            if (this.ignoreParameterInit(params, firstParamValue, key, value)) {
                return;
            }
            if (this.useDefaultedKey(key, value)) {
                key = LiteralSupport.isStringLiteral(value) ? value.substring(1, value.length() - 1) : value;
            }
            paramConsumer.accept(key, value);
        }

        protected boolean useDefaultedKey(String key, String value) {
            return LiteralSupport.INTEGER_LITERAL_PATTERN.matcher(key).matches() && this.isSinglePart(value);
        }

        protected boolean isSinglePart(String value) {
            return Expressions.splitParts(value).size() == 1 && !WHITESPACE.matcher(value).find();
        }

        protected boolean ignoreParameterInit(Map<String, String> params, Supplier<String> firstParamSupplier, String key, String value) {
            return key.equals(IGNORE_FRAGMENTS);
        }

        protected abstract T newHelper(TemplateSupplier var1, Map<String, Expression> var2, Map<String, SectionBlock> var3, Boolean var4, SectionHelperFactory.SectionInitContext var5);
    }

    public static class Factory
    extends AbstractIncludeFactory<IncludeSectionHelper> {
        static final String DYNAMIC_ID = "_id";

        @Override
        public List<String> getDefaultAliases() {
            return ImmutableList.of("include");
        }

        @Override
        public SectionHelperFactory.ParametersInfo getParameters() {
            SectionHelperFactory.ParametersInfo.Builder builder = SectionHelperFactory.ParametersInfo.builder().addParameter(Parameter.builder(IncludeSectionHelper.TEMPLATE).optional().valuePredicate(this::skipBuiltInParam).build()).addParameter(Parameter.builder(DYNAMIC_ID).optional().valuePredicate(this::skipBuiltInParam).build());
            this.addDefaultParams(builder);
            return builder.build();
        }

        @Override
        public SectionHelperFactory.MissingEndTagStrategy missingEndTagStrategy() {
            return SectionHelperFactory.MissingEndTagStrategy.BIND_TO_PARENT;
        }

        @Override
        protected boolean ignoreParameterInit(Map<String, String> params, Supplier<String> firstParamValue, String key, String value) {
            return key.equals(IncludeSectionHelper.TEMPLATE) || key.equals("_isolated") || value.equals("_isolated") || value.equals("_unisolated") || key.equals("_ignoreFragments") || value.equals("_ignoreFragments");
        }

        @Override
        protected String getTemplateId(SectionHelperFactory.SectionInitContext context) {
            if (context.getParameters().containsKey(DYNAMIC_ID)) {
                return null;
            }
            String templateParam = context.getParameter(IncludeSectionHelper.TEMPLATE);
            if (templateParam == null) {
                throw context.error("Neither the template id nor the template name was specified").build();
            }
            if (LiteralSupport.isStringLiteralSeparator(templateParam.charAt(0))) {
                templateParam = templateParam.substring(1, templateParam.length() - 1);
            }
            return templateParam;
        }

        @Override
        protected IncludeSectionHelper newHelper(TemplateSupplier templateSupplier, Map<String, Expression> params, Map<String, SectionBlock> extendingBlocks, Boolean isolatedValue, SectionHelperFactory.SectionInitContext context) {
            return new IncludeSectionHelper(templateSupplier, extendingBlocks, params, isolatedValue != null ? isolatedValue : Boolean.parseBoolean(context.getParameterOrDefault("_isolated", Boolean.FALSE.toString())));
        }
    }
}

