/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next;

import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;

public class CloseReason {
    public static final CloseReason NORMAL = new CloseReason(WebSocketCloseStatus.NORMAL_CLOSURE.code());
    public static final CloseReason ABNORMAL = new CloseReason(WebSocketCloseStatus.ABNORMAL_CLOSURE.code(), null, false);
    public static final CloseReason EMPTY = new CloseReason(WebSocketCloseStatus.EMPTY.code(), null, false);
    public static final CloseReason INTERNAL_SERVER_ERROR = new CloseReason(WebSocketCloseStatus.INTERNAL_SERVER_ERROR.code());
    private final int code;
    private final String message;

    private CloseReason(int code, String message, boolean validate) {
        if (validate && !WebSocketCloseStatus.isValidStatusCode((int)code)) {
            throw new IllegalArgumentException("Invalid status code: " + code);
        }
        this.code = code;
        this.message = message;
    }

    public CloseReason(int code) {
        this(code, null, true);
    }

    public CloseReason(int code, String message) {
        this(code, message, true);
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return "CloseReason [code=" + this.code + ", " + (String)(this.message != null ? "message=" + this.message : "") + "]";
    }
}

