/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.runtime.telemetry;

import io.micrometer.core.instrument.Counter;
import io.quarkus.websockets.next.runtime.telemetry.SendingInterceptor;
import io.vertx.core.buffer.Buffer;
import java.nio.charset.StandardCharsets;

final class MetricsSendingInterceptor
implements SendingInterceptor {
    private final Counter onMessageSentCounter;
    private final Counter onMessageSentBytesCounter;

    MetricsSendingInterceptor(Counter onMessageSentCounter, Counter onMessageSentBytesCounter) {
        this.onMessageSentCounter = onMessageSentCounter;
        this.onMessageSentBytesCounter = onMessageSentBytesCounter;
    }

    @Override
    public void onSend(String text) {
        this.onMessageSentCounter.increment();
        this.onMessageSentBytesCounter.increment((double)text.getBytes(StandardCharsets.UTF_8).length);
    }

    @Override
    public void onSend(Buffer message) {
        this.onMessageSentCounter.increment();
        this.onMessageSentBytesCounter.increment((double)message.getBytes().length);
    }
}

