/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.runtime.telemetry;

import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.Tracer;
import io.quarkus.websockets.next.WebSocketClientConnection;
import io.quarkus.websockets.next.WebSocketConnection;
import io.quarkus.websockets.next.runtime.WebSocketEndpoint;
import io.quarkus.websockets.next.runtime.config.WebSocketsClientRuntimeConfig;
import io.quarkus.websockets.next.runtime.config.WebSocketsServerRuntimeConfig;
import io.quarkus.websockets.next.runtime.telemetry.ConnectionInterceptor;
import io.quarkus.websockets.next.runtime.telemetry.TelemetryWebSocketEndpointContext;
import io.quarkus.websockets.next.runtime.telemetry.TracesConnectionInterceptor;
import io.quarkus.websockets.next.runtime.telemetry.TracesForwardingWebSocketEndpoint;
import io.quarkus.websockets.next.runtime.telemetry.WebSocketTelemetryProviderBuilder;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.util.function.Consumer;
import java.util.function.Function;

public final class TracesBuilderCustomizer
implements Consumer<WebSocketTelemetryProviderBuilder> {
    @Inject
    WebSocketsServerRuntimeConfig serverRuntimeConfig;
    @Inject
    WebSocketsClientRuntimeConfig clientRuntimeConfig;
    @Inject
    Instance<Tracer> tracerInstance;

    @Override
    public void accept(WebSocketTelemetryProviderBuilder builder) {
        boolean serverTracesEnabled = this.serverRuntimeConfig.telemetry().tracesEnabled();
        boolean clientTracesEnabled = this.clientRuntimeConfig.telemetry().tracesEnabled();
        if (serverTracesEnabled || clientTracesEnabled) {
            Tracer tracer = (Tracer)this.tracerInstance.get();
            if (serverTracesEnabled) {
                TracesBuilderCustomizer.addServerTracesSupport(builder, tracer);
            }
            if (clientTracesEnabled) {
                TracesBuilderCustomizer.addClientTracesSupport(builder, tracer);
            }
        }
    }

    private static void addServerTracesSupport(WebSocketTelemetryProviderBuilder builder, final Tracer tracer) {
        builder.serverEndpointDecorator(new Function<TelemetryWebSocketEndpointContext, WebSocketEndpoint>(){

            @Override
            public WebSocketEndpoint apply(TelemetryWebSocketEndpointContext ctx) {
                SpanContext onOpenSpanCtx = (SpanContext)ctx.contextData().get("io.quarkus.websockets.next.connection-opened-span-ctx");
                return new TracesForwardingWebSocketEndpoint(ctx.endpoint(), tracer, (WebSocketConnection)((Object)ctx.connection()), onOpenSpanCtx, ctx.path());
            }
        });
        builder.pathToServerConnectionInterceptor(new Function<String, ConnectionInterceptor>(){

            @Override
            public ConnectionInterceptor apply(String path) {
                return new TracesConnectionInterceptor(tracer, SpanKind.SERVER, path);
            }
        });
    }

    private static void addClientTracesSupport(WebSocketTelemetryProviderBuilder builder, final Tracer tracer) {
        builder.clientEndpointDecorator(new Function<TelemetryWebSocketEndpointContext, WebSocketEndpoint>(){

            @Override
            public WebSocketEndpoint apply(TelemetryWebSocketEndpointContext ctx) {
                SpanContext onOpenSpanCtx = (SpanContext)ctx.contextData().get("io.quarkus.websockets.next.connection-opened-span-ctx");
                return new TracesForwardingWebSocketEndpoint(ctx.endpoint(), tracer, (WebSocketClientConnection)((Object)ctx.connection()), onOpenSpanCtx, ctx.path());
            }
        });
        builder.pathToClientConnectionInterceptor(new Function<String, ConnectionInterceptor>(){

            @Override
            public ConnectionInterceptor apply(String path) {
                return new TracesConnectionInterceptor(tracer, SpanKind.CLIENT, path);
            }
        });
    }
}

