/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.deployment.devui;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsLocalDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.devui.spi.JsonRPCProvidersBuildItem;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.devui.spi.page.WebComponentPageBuilder;
import io.quarkus.websockets.next.deployment.Callback;
import io.quarkus.websockets.next.deployment.GeneratedEndpointBuildItem;
import io.quarkus.websockets.next.deployment.WebSocketEndpointBuildItem;
import io.quarkus.websockets.next.deployment.WebSocketProcessor;
import io.quarkus.websockets.next.runtime.dev.ui.WebSocketNextJsonRPCService;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;

public class WebSocketServerDevUIProcessor {
    @BuildStep(onlyIf={IsLocalDevelopment.class})
    public void pages(List<WebSocketEndpointBuildItem> endpoints, List<GeneratedEndpointBuildItem> generatedEndpoints, BuildProducer<CardPageBuildItem> cardPages) {
        CardPageBuildItem pageBuildItem = new CardPageBuildItem();
        pageBuildItem.addBuildTimeData("endpoints", this.createEndpointsJson(endpoints, generatedEndpoints));
        pageBuildItem.addPage((PageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().title("Server Endpoints")).icon("font-awesome-solid:plug")).componentLink("qwc-wsn-endpoints.js").staticLabel(String.valueOf(endpoints.stream().filter(WebSocketEndpointBuildItem::isServer).count())));
        cardPages.produce((BuildItem)pageBuildItem);
    }

    @BuildStep(onlyIf={IsLocalDevelopment.class})
    JsonRPCProvidersBuildItem rpcProvider() {
        return new JsonRPCProvidersBuildItem(WebSocketNextJsonRPCService.class);
    }

    private List<Map<String, Object>> createEndpointsJson(List<WebSocketEndpointBuildItem> endpoints, List<GeneratedEndpointBuildItem> generatedEndpoints) {
        ArrayList<Map<String, Object>> json = new ArrayList<Map<String, Object>>();
        for (WebSocketEndpointBuildItem endpoint : endpoints.stream().filter(WebSocketEndpointBuildItem::isServer).sorted(Comparator.comparing(e -> e.path)).collect(Collectors.toList())) {
            HashMap<String, Object> endpointJson = new HashMap<String, Object>();
            String clazz = endpoint.bean.getImplClazz().name().toString();
            endpointJson.put("clazz", clazz);
            endpointJson.put("generatedClazz", generatedEndpoints.stream().filter((Predicate<GeneratedEndpointBuildItem>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$createEndpointsJson$1(java.lang.String io.quarkus.websockets.next.deployment.GeneratedEndpointBuildItem ), (Lio/quarkus/websockets/next/deployment/GeneratedEndpointBuildItem;)Z)((String)clazz)).findFirst().orElseThrow().generatedClassName);
            endpointJson.put("path", WebSocketProcessor.getOriginalPath(endpoint.path));
            endpointJson.put("executionMode", endpoint.inboundProcessingMode.toString());
            ArrayList<Map<String, Object>> callbacks = new ArrayList<Map<String, Object>>();
            this.addCallback(endpoint.onOpen, callbacks);
            this.addCallback(endpoint.onBinaryMessage, callbacks);
            this.addCallback(endpoint.onTextMessage, callbacks);
            this.addCallback(endpoint.onPingMessage, callbacks);
            this.addCallback(endpoint.onPongMessage, callbacks);
            this.addCallback(endpoint.onClose, callbacks);
            for (Callback c : endpoint.onErrors) {
                this.addCallback(c, callbacks);
            }
            endpointJson.put("callbacks", callbacks);
            json.add(endpointJson);
        }
        return json;
    }

    private void addCallback(Callback callback, List<Map<String, Object>> callbacks) {
        if (callback != null) {
            callbacks.add(Map.of("annotation", callback.annotation.toString(), "method", this.methodToString(callback.method)));
        }
    }

    private String methodToString(MethodInfo method) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.typeToString(method.returnType())).append(' ').append(method.name()).append('(');
        Iterator it = method.parameters().iterator();
        while (it.hasNext()) {
            MethodParameterInfo p = (MethodParameterInfo)it.next();
            builder.append(this.typeToString(p.type()));
            builder.append(' ');
            builder.append((String)(p.name() != null ? p.name() : "arg" + p.position()));
            if (!it.hasNext()) continue;
            builder.append(", ");
        }
        builder.append(')');
        if (!method.exceptions().isEmpty()) {
            builder.append(" throws ");
            it = method.exceptions().iterator();
            while (it.hasNext()) {
                builder.append(this.typeToString((Type)it.next()));
                if (!it.hasNext()) continue;
                builder.append(", ");
            }
        }
        return builder.toString();
    }

    private String typeToString(Type type) {
        if (type.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            ParameterizedType parameterizedType = type.asParameterizedType();
            StringBuilder builder = new StringBuilder();
            builder.append(parameterizedType.name().withoutPackagePrefix());
            if (!parameterizedType.arguments().isEmpty()) {
                builder.append('<');
                Iterator it = parameterizedType.arguments().iterator();
                while (it.hasNext()) {
                    builder.append(this.typeToString((Type)it.next()));
                    if (!it.hasNext()) continue;
                    builder.append(", ");
                }
                builder.append('>');
            }
            return builder.toString();
        }
        return type.name().withoutPackagePrefix();
    }

    private static /* synthetic */ boolean lambda$createEndpointsJson$1(String clazz, GeneratedEndpointBuildItem ge) {
        return ge.endpointClassName.equals(clazz);
    }
}

