/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime.client.secretengine;

import io.quarkus.vault.runtime.client.VaultInternalBase;
import io.quarkus.vault.runtime.client.dto.totp.VaultTOTPCreateKeyBody;
import io.quarkus.vault.runtime.client.dto.totp.VaultTOTPCreateKeyResult;
import io.quarkus.vault.runtime.client.dto.totp.VaultTOTPGenerateCodeResult;
import io.quarkus.vault.runtime.client.dto.totp.VaultTOTPListKeysResult;
import io.quarkus.vault.runtime.client.dto.totp.VaultTOTPReadKeyResult;
import io.quarkus.vault.runtime.client.dto.totp.VaultTOTPValidateCodeBody;
import io.quarkus.vault.runtime.client.dto.totp.VaultTOTPValidateCodeResult;
import javax.inject.Singleton;

@Singleton
public class VaultInternalTOPTSecretEngine
extends VaultInternalBase {
    public VaultTOTPCreateKeyResult createTOTPKey(String token, String keyName, VaultTOTPCreateKeyBody body) {
        String path = "totp/keys/" + keyName;
        if (body.isProducingOutput()) {
            return this.vaultClient.post(path, token, body, VaultTOTPCreateKeyResult.class, 200);
        }
        this.vaultClient.post(path, token, (Object)body, 204);
        return null;
    }

    public VaultTOTPReadKeyResult readTOTPKey(String token, String keyName) {
        String path = "totp/keys/" + keyName;
        return this.vaultClient.get(path, token, VaultTOTPReadKeyResult.class);
    }

    public VaultTOTPListKeysResult listTOTPKeys(String token) {
        return this.vaultClient.list("totp/keys", token, VaultTOTPListKeysResult.class);
    }

    public void deleteTOTPKey(String token, String keyName) {
        String path = "totp/keys/" + keyName;
        this.vaultClient.delete(path, token, 204);
    }

    public VaultTOTPGenerateCodeResult generateTOTPCode(String token, String keyName) {
        String path = "totp/code/" + keyName;
        return this.vaultClient.get(path, token, VaultTOTPGenerateCodeResult.class);
    }

    public VaultTOTPValidateCodeResult validateTOTPCode(String token, String keyName, String code) {
        String path = "totp/code/" + keyName;
        VaultTOTPValidateCodeBody body = new VaultTOTPValidateCodeBody(code);
        return this.vaultClient.post(path, token, (Object)body, VaultTOTPValidateCodeResult.class);
    }
}

