/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime;

import io.quarkus.credentials.CredentialsProvider;
import io.quarkus.vault.VaultException;
import io.quarkus.vault.VaultKVSecretEngine;
import io.quarkus.vault.runtime.VaultConfigHolder;
import io.quarkus.vault.runtime.VaultDbManager;
import io.quarkus.vault.runtime.config.CredentialsProviderConfig;
import io.quarkus.vault.runtime.config.VaultBootstrapConfig;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;

@ApplicationScoped
@Named(value="vault-credentials-provider")
public class VaultCredentialsProvider
implements CredentialsProvider {
    @Inject
    private VaultKVSecretEngine vaultKVSecretEngine;
    @Inject
    private VaultDbManager vaultDbManager;
    @Inject
    private VaultConfigHolder vaultConfigHolder;

    public Map<String, String> getCredentials(String credentialsProviderName) {
        CredentialsProviderConfig config = this.getConfig().credentialsProvider.get(credentialsProviderName);
        if (config == null) {
            throw new VaultException("unknown credentials provider with name " + credentialsProviderName);
        }
        if (config.databaseCredentialsRole.isPresent()) {
            return this.vaultDbManager.getDynamicDbCredentials(config.databaseCredentialsRole.get());
        }
        if (config.kvPath.isPresent()) {
            String password = this.vaultKVSecretEngine.readSecret(config.kvPath.get()).get(config.kvKey);
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("password", password);
            return result;
        }
        throw new VaultException("one of database-credentials-role or kv-path is required on credentials provider " + credentialsProviderName);
    }

    private VaultBootstrapConfig getConfig() {
        return this.vaultConfigHolder.getVaultBootstrapConfig();
    }
}

