/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.vertx;

import io.quarkus.test.vertx.UniAsserter;
import io.smallrye.mutiny.Uni;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.junit.jupiter.api.Assertions;

public final class DefaultUniAsserter
implements UniAsserter {
    private final ConcurrentMap<String, Object> data;
    Uni<?> execution = Uni.createFrom().item(new Object());

    public DefaultUniAsserter() {
        this.data = new ConcurrentHashMap<String, Object>();
    }

    @Override
    public <T> UniAsserter assertThat(Supplier<Uni<T>> uni, final Consumer<T> asserter) {
        this.execution = this.uniFromSupplier(uni).onItem().invoke((Consumer)new Consumer<Object>(){

            @Override
            public void accept(Object o) {
                asserter.accept(o);
            }
        });
        return this;
    }

    @Override
    public <T> UniAsserter execute(Supplier<Uni<T>> uni) {
        this.execution = this.uniFromSupplier(uni);
        return this;
    }

    @Override
    public UniAsserter execute(Runnable c) {
        this.execution = this.execution.onItem().invoke(c);
        return this;
    }

    @Override
    public <T> UniAsserter assertEquals(Supplier<Uni<T>> uni, final T t) {
        this.execution = this.uniFromSupplier(uni).onItem().invoke((Consumer)new Consumer<Object>(){

            @Override
            public void accept(Object o) {
                Assertions.assertEquals((Object)t, (Object)o);
            }
        });
        return this;
    }

    @Override
    public <T> UniAsserter assertSame(Supplier<Uni<T>> uni, final T t) {
        this.execution = this.uniFromSupplier(uni).onItem().invoke((Consumer)new Consumer<Object>(){

            @Override
            public void accept(Object o) {
                Assertions.assertSame((Object)t, (Object)o);
            }
        });
        return this;
    }

    @Override
    public <T> UniAsserter assertNull(Supplier<Uni<T>> uni) {
        this.execution = this.uniFromSupplier(uni).onItem().invoke(Assertions::assertNull);
        return this;
    }

    private <T> Uni<T> uniFromSupplier(final Supplier<Uni<T>> uni) {
        return this.execution.onItem().transformToUni(new Function<Object, Uni<T>>(){

            @Override
            public Uni<T> apply(Object o) {
                return (Uni)uni.get();
            }
        });
    }

    @Override
    public <T> UniAsserter assertNotEquals(Supplier<Uni<T>> uni, final T t) {
        this.execution = this.uniFromSupplier(uni).onItem().invoke((Consumer)new Consumer<Object>(){

            @Override
            public void accept(Object o) {
                Assertions.assertNotEquals((Object)t, (Object)o);
            }
        });
        return this;
    }

    @Override
    public <T> UniAsserter assertNotSame(Supplier<Uni<T>> uni, final T t) {
        this.execution = this.uniFromSupplier(uni).onItem().invoke((Consumer)new Consumer<Object>(){

            @Override
            public void accept(Object o) {
                Assertions.assertNotSame((Object)t, (Object)o);
            }
        });
        return this;
    }

    @Override
    public <T> UniAsserter assertNotNull(Supplier<Uni<T>> uni) {
        this.execution = this.uniFromSupplier(uni).onItem().invoke(Assertions::assertNotNull);
        return this;
    }

    @Override
    public <T> UniAsserter surroundWith(Function<Uni<T>, Uni<T>> uni) {
        this.execution = uni.apply(this.execution);
        return this;
    }

    @Override
    public UniAsserter assertFalse(Supplier<Uni<Boolean>> uni) {
        this.execution = this.uniFromSupplier(uni).onItem().invoke(Assertions::assertFalse);
        return this;
    }

    @Override
    public UniAsserter assertTrue(Supplier<Uni<Boolean>> uni) {
        this.execution = this.uniFromSupplier(uni).onItem().invoke(Assertions::assertTrue);
        return this;
    }

    @Override
    public UniAsserter fail() {
        this.execution = this.execution.onItem().invoke(v -> Assertions.fail());
        return this;
    }

    @Override
    public <T> UniAsserter assertFailedWith(final Supplier<Uni<T>> uni, final Consumer<Throwable> c) {
        this.execution = this.execution.onItem().transformToUni(new Function<Object, Uni<T>>(){

            @Override
            public Uni<T> apply(Object obj) {
                return ((Uni)uni.get()).onItemOrFailure().transformToUni((o, t) -> {
                    if (t == null) {
                        return Uni.createFrom().failure(() -> (Throwable)Assertions.fail((String)"Uni did not contain a failure."));
                    }
                    return Uni.createFrom().item(() -> {
                        c.accept(t);
                        return null;
                    });
                });
            }
        });
        return this;
    }

    @Override
    public <T> UniAsserter assertFailedWith(Supplier<Uni<T>> uni, Class<? extends Throwable> c) {
        return this.assertFailedWith(uni, (Throwable t) -> {
            if (!c.isInstance(t)) {
                Assertions.fail((String)String.format("Uni failure type '%s' was not of the expected type '%s'.", t.getClass().getName(), c.getName()));
            }
        });
    }

    @Override
    public Object getData(String key) {
        return this.data.get(key);
    }

    @Override
    public Object putData(String key, Object value) {
        return this.data.put(key, value);
    }

    @Override
    public void clearData() {
        this.data.clear();
    }
}

