/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.mongodb;

import de.flapdoodle.embed.mongo.commands.MongodArguments;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.mongo.distribution.Version;
import de.flapdoodle.embed.mongo.distribution.Versions;
import de.flapdoodle.embed.mongo.transitions.Mongod;
import de.flapdoodle.embed.mongo.transitions.RunningMongodProcess;
import de.flapdoodle.embed.process.distribution.Version;
import de.flapdoodle.reverse.Listener;
import de.flapdoodle.reverse.Transition;
import de.flapdoodle.reverse.TransitionWalker;
import de.flapdoodle.reverse.transitions.Start;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.jboss.logging.Logger;

public class MongoTestResource
implements QuarkusTestResourceLifecycleManager {
    public static final String PORT = "port";
    public static final String VERSION = "version";
    static final int DEFAULT_PORT = 27017;
    private static final Logger LOGGER = Logger.getLogger(MongoTestResource.class);
    private Integer port;
    private IFeatureAwareVersion version;
    private TransitionWalker.ReachedState<RunningMongodProcess> startedServer;

    public static int port(Map<String, String> initArgs) {
        return Optional.ofNullable(initArgs.get(PORT)).map(Integer::parseInt).orElse(27017);
    }

    public static IFeatureAwareVersion version(Map<String, String> initArgs) {
        Optional<String> versionArg = Optional.ofNullable(initArgs.get(VERSION));
        return versionArg.map(Version.Main::valueOf).orElseGet(() -> versionArg.map(versionStr -> Versions.withFeatures((Version)Version.of((String)versionStr))).orElse((IFeatureAwareVersion)Version.Main.V4_0));
    }

    public static void forceExtendedSocketOptionsClassInit() {
        try {
            Class.forName("sun.net.ext.ExtendedSocketOptions", true, ClassLoader.getSystemClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void init(Map<String, String> initArgs) {
        this.port = MongoTestResource.port(initArgs);
        this.version = MongoTestResource.version(initArgs);
    }

    public Map<String, String> start() {
        MongoTestResource.forceExtendedSocketOptionsClassInit();
        LOGGER.infof("Starting Mongo %s on port %s", (Object)this.version, (Object)this.port);
        this.startedServer = Mongod.instance().withNet((Transition)Start.to(Net.class).initializedWith((Object)Net.builder().from(Net.defaults()).port(this.port.intValue()).build())).withMongodArguments((Transition)Start.to(MongodArguments.class).initializedWith((Object)MongodArguments.defaults().withUseNoJournal(false))).start((Version)this.version, new Listener[0]);
        return Collections.singletonMap("quarkus.mongodb.hosts", String.format("127.0.0.1:%d", this.port));
    }

    public void stop() {
        if (this.startedServer != null) {
            this.startedServer.close();
            this.startedServer = null;
        }
    }
}

