/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.kafka;

import io.quarkus.test.common.DevServicesContext;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import io.quarkus.test.kafka.InjectKafkaCompanion;
import io.smallrye.reactive.messaging.kafka.companion.KafkaCompanion;
import io.strimzi.test.container.StrimziKafkaContainer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.awaitility.Awaitility;

public class KafkaCompanionResource
implements QuarkusTestResourceLifecycleManager,
DevServicesContext.ContextAware {
    public static String STRIMZI_KAFKA_IMAGE_KEY = "strimzi.kafka.image";
    public static String KAFKA_PORT_KEY = "kafka.port";
    public static String KRAFT_KEY = "kraft";
    protected String strimziKafkaContainerImage;
    protected Integer kafkaPort;
    protected boolean kraft;
    protected StrimziKafkaContainer kafka;
    protected KafkaCompanion kafkaCompanion;

    public void setIntegrationTestContext(DevServicesContext context) {
        Map devServicesProperties = context.devServicesProperties();
        String bootstrapServers = (String)devServicesProperties.get("kafka.bootstrap.servers");
        if (bootstrapServers != null) {
            this.kafkaCompanion = new KafkaCompanion(bootstrapServers);
            String apicurioUrl = (String)devServicesProperties.get("mp.messaging.connector.smallrye-kafka.apicurio.registry.url");
            if (apicurioUrl != null) {
                String confluentUrl = (String)devServicesProperties.get("mp.messaging.connector.smallrye-kafka.schema.registry.url");
                this.kafkaCompanion.setCommonClientConfig(Map.of("apicurio.registry.url", apicurioUrl, "apicurio.registry.auto-register", "true", "schema.registry.url", confluentUrl));
            }
        }
    }

    protected StrimziKafkaContainer createContainer(String imageName) {
        if (imageName == null) {
            return new StrimziKafkaContainer();
        }
        return new StrimziKafkaContainer(imageName);
    }

    public void init(Map<String, String> initArgs) {
        if (this.kafkaCompanion == null) {
            this.strimziKafkaContainerImage = initArgs.get(STRIMZI_KAFKA_IMAGE_KEY);
            String portString = initArgs.get(KAFKA_PORT_KEY);
            this.kafkaPort = portString == null ? null : Integer.valueOf(Integer.parseInt(portString));
            this.kraft = Boolean.parseBoolean(initArgs.get(KRAFT_KEY));
            this.kafka = this.createContainer(this.strimziKafkaContainerImage);
            if (this.kraft) {
                this.kafka.withBrokerId(1).withKraft();
            }
            if (this.kafkaPort != null) {
                this.kafka.withPort(this.kafkaPort.intValue());
            }
            HashMap<String, String> configMap = new HashMap<String, String>(initArgs);
            configMap.remove(STRIMZI_KAFKA_IMAGE_KEY);
            configMap.remove(KAFKA_PORT_KEY);
            configMap.remove(KRAFT_KEY);
            this.kafka.withKafkaConfigurationMap(configMap);
        }
    }

    public Map<String, String> start() {
        if (this.kafkaCompanion == null && this.kafka != null) {
            this.kafka.start();
            Awaitility.await().until(() -> ((StrimziKafkaContainer)this.kafka).isRunning());
            this.kafkaCompanion = new KafkaCompanion(this.kafka.getBootstrapServers());
            return Collections.singletonMap("kafka.bootstrap.servers", this.kafka.getBootstrapServers());
        }
        return Collections.emptyMap();
    }

    public void stop() {
        if (this.kafkaCompanion != null) {
            this.kafkaCompanion.close();
        }
        if (this.kafka != null) {
            this.kafka.close();
        }
    }

    public void inject(QuarkusTestResourceLifecycleManager.TestInjector testInjector) {
        testInjector.injectIntoFields((Object)this.kafkaCompanion, (Predicate)new QuarkusTestResourceLifecycleManager.TestInjector.AnnotatedAndMatchesType(InjectKafkaCompanion.class, KafkaCompanion.class));
    }
}

