/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.common;

import io.quarkus.fs.util.ZipUtils;
import io.quarkus.test.common.PathTestHelper;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;
import org.jboss.jandex.IndexWriter;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.UnsupportedVersion;

public final class TestClassIndexer {
    private TestClassIndexer() {
    }

    public static Index indexTestClasses(Class<?> testClass) {
        return TestClassIndexer.indexTestClasses(PathTestHelper.getTestClassesLocation(testClass));
    }

    public static Index indexTestClasses(Path testClassesLocation) {
        Indexer indexer;
        block10: {
            indexer = new Indexer();
            try {
                if (Files.isDirectory(testClassesLocation, new LinkOption[0])) {
                    TestClassIndexer.indexTestClassesDir(indexer, testClassesLocation);
                    break block10;
                }
                try (FileSystem jarFs = ZipUtils.newFileSystem((Path)testClassesLocation);){
                    for (Path p : jarFs.getRootDirectories()) {
                        TestClassIndexer.indexTestClassesDir(indexer, p);
                    }
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable to index the test-classes/ directory.", e);
            }
        }
        return indexer.complete();
    }

    public static void writeIndex(Index index, Class<?> testClass) {
        TestClassIndexer.writeIndex(index, PathTestHelper.getTestClassesLocation(testClass), testClass);
    }

    public static void writeIndex(Index index, Path testClassLocation, Class<?> testClass) {
        try (FileOutputStream fos = new FileOutputStream(TestClassIndexer.indexPath(testClassLocation, testClass).toFile(), false);){
            IndexWriter indexWriter = new IndexWriter((OutputStream)fos);
            indexWriter.write(index);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Index readIndex(Class<?> testClass) {
        return TestClassIndexer.readIndex(PathTestHelper.getTestClassesLocation(testClass), testClass);
    }

    public static Index readIndex(Path testClassLocation, Class<?> testClass) {
        Path path = TestClassIndexer.indexPath(testClassLocation, testClass);
        if (path.toFile().exists()) {
            Index index;
            FileInputStream fis = new FileInputStream(path.toFile());
            try {
                index = new IndexReader((InputStream)fis).read();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        fis.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (UnsupportedVersion e) {
                    throw new UnsupportedVersion("Can't read Jandex index from " + String.valueOf(path) + ": " + e.getMessage());
                }
                catch (IOException e) {
                    return TestClassIndexer.indexTestClasses(testClass);
                }
            }
            fis.close();
            return index;
        }
        return TestClassIndexer.indexTestClasses(testClass);
    }

    private static Path indexPath(Class<?> testClass) {
        return TestClassIndexer.indexPath(PathTestHelper.getTestClassesLocation(testClass), testClass);
    }

    private static Path indexPath(Path testClassLocation, Class<?> testClass) {
        return testClassLocation.resolve(testClass.getSimpleName() + ".idx");
    }

    private static void indexTestClassesDir(final Indexer indexer, Path testClassesLocation) throws IOException {
        Files.walkFileTree(testClassesLocation, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (!file.toString().endsWith(".class")) {
                    return FileVisitResult.CONTINUE;
                }
                try (InputStream inputStream = Files.newInputStream(file, StandardOpenOption.READ);){
                    indexer.index(inputStream);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void removeIndex(Class<?> requiredTestClass) {
        Path indexPath = TestClassIndexer.indexPath(requiredTestClass);
        if (Files.exists(indexPath, new LinkOption[0])) {
            try {
                Files.delete(indexPath);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to delete file index", e);
            }
        }
    }
}

