/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.data.rest.deployment.crud;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.panache.common.Page;
import io.quarkus.panache.common.Sort;
import io.quarkus.spring.data.rest.deployment.ResourceMethodsImplementor;
import io.quarkus.spring.data.rest.deployment.crud.EntityClassHelper;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.springframework.data.repository.CrudRepository;

public class CrudMethodsImplementor
implements ResourceMethodsImplementor {
    public static final MethodDescriptor LIST = MethodDescriptor.ofMethod(CrudRepository.class, (String)"findAll", Iterable.class, (Class[])new Class[0]);
    public static final MethodDescriptor GET = MethodDescriptor.ofMethod(CrudRepository.class, (String)"findById", Optional.class, (Class[])new Class[]{Object.class});
    public static final MethodDescriptor ADD = MethodDescriptor.ofMethod(CrudRepository.class, (String)"save", Object.class, (Class[])new Class[]{Object.class});
    public static final MethodDescriptor UPDATE = MethodDescriptor.ofMethod(CrudRepository.class, (String)"save", Object.class, (Class[])new Class[]{Object.class});
    public static final MethodDescriptor DELETE = MethodDescriptor.ofMethod(CrudRepository.class, (String)"deleteById", Void.TYPE, (Class[])new Class[]{Object.class});
    private final EntityClassHelper entityClassHelper;

    public CrudMethodsImplementor(IndexView index) {
        this.entityClassHelper = new EntityClassHelper(index);
    }

    @Override
    public void implementList(ClassCreator classCreator, String repositoryInterface) {
        MethodCreator methodCreator = classCreator.getMethodCreator("list", List.class, new Class[]{Page.class, Sort.class, String.class, Map.class});
        ResultHandle repository = this.getRepositoryInstance((BytecodeCreator)methodCreator, repositoryInterface);
        ResultHandle result = methodCreator.invokeInterfaceMethod(LIST, repository, new ResultHandle[0]);
        methodCreator.returnValue(result);
        methodCreator.close();
    }

    @Override
    public void implementListPageCount(ClassCreator classCreator, String repositoryInterface) {
        MethodCreator methodCreator = classCreator.getMethodCreator("$$_page_count_list", Integer.TYPE, new Class[]{Page.class});
        methodCreator.throwException(RuntimeException.class, "Method not implemented");
        methodCreator.close();
    }

    @Override
    public void implementGet(ClassCreator classCreator, String repositoryInterface) {
        MethodCreator methodCreator = classCreator.getMethodCreator("get", Object.class, new Class[]{Object.class});
        ResultHandle id = methodCreator.getMethodParam(0);
        ResultHandle repository = this.getRepositoryInstance((BytecodeCreator)methodCreator, repositoryInterface);
        ResultHandle result = this.findById((BytecodeCreator)methodCreator, id, repository);
        methodCreator.returnValue(result);
        methodCreator.close();
    }

    @Override
    public void implementAdd(ClassCreator classCreator, String repositoryInterface) {
        MethodCreator methodCreator = classCreator.getMethodCreator("add", Object.class, new Class[]{Object.class});
        ResultHandle entity = methodCreator.getMethodParam(0);
        ResultHandle repository = this.getRepositoryInstance((BytecodeCreator)methodCreator, repositoryInterface);
        ResultHandle result = methodCreator.invokeInterfaceMethod(ADD, repository, new ResultHandle[]{entity});
        methodCreator.returnValue(result);
        methodCreator.close();
    }

    @Override
    public void implementUpdate(ClassCreator classCreator, String repositoryInterface, String entityType) {
        MethodCreator methodCreator = classCreator.getMethodCreator("update", Object.class, new Class[]{Object.class, Object.class});
        ResultHandle id = methodCreator.getMethodParam(0);
        ResultHandle entity = methodCreator.getMethodParam(1);
        this.setId((BytecodeCreator)methodCreator, entityType, entity, id);
        ResultHandle repository = this.getRepositoryInstance((BytecodeCreator)methodCreator, repositoryInterface);
        ResultHandle result = methodCreator.invokeInterfaceMethod(UPDATE, repository, new ResultHandle[]{entity});
        methodCreator.returnValue(result);
        methodCreator.close();
    }

    @Override
    public void implementDelete(ClassCreator classCreator, String repositoryInterface) {
        MethodCreator methodCreator = classCreator.getMethodCreator("delete", Boolean.TYPE, new Class[]{Object.class});
        ResultHandle id = methodCreator.getMethodParam(0);
        ResultHandle repository = this.getRepositoryInstance((BytecodeCreator)methodCreator, repositoryInterface);
        ResultHandle entity = this.findById((BytecodeCreator)methodCreator, id, repository);
        AssignableResultHandle result = methodCreator.createVariable(Boolean.TYPE);
        BranchResult entityExists = methodCreator.ifNotNull(entity);
        entityExists.trueBranch().invokeInterfaceMethod(DELETE, repository, new ResultHandle[]{id});
        entityExists.trueBranch().assign(result, entityExists.trueBranch().load(true));
        entityExists.falseBranch().assign(result, entityExists.falseBranch().load(false));
        methodCreator.returnValue((ResultHandle)result);
        methodCreator.close();
    }

    private ResultHandle findById(BytecodeCreator creator, ResultHandle id, ResultHandle repository) {
        ResultHandle optional = creator.invokeInterfaceMethod(GET, repository, new ResultHandle[]{id});
        return creator.invokeVirtualMethod(MethodDescriptor.ofMethod(Optional.class, (String)"orElse", Object.class, (Class[])new Class[]{Object.class}), optional, new ResultHandle[]{creator.loadNull()});
    }

    private void setId(BytecodeCreator creator, String entityType, ResultHandle entity, ResultHandle id) {
        FieldInfo idField = this.entityClassHelper.getIdField(entityType);
        MethodDescriptor idSetter = this.entityClassHelper.getSetter(entityType, idField);
        creator.invokeVirtualMethod(idSetter, entity, new ResultHandle[]{id});
    }

    protected ResultHandle getRepositoryInstance(BytecodeCreator creator, String repositoryInterface) {
        ResultHandle arcContainer = creator.invokeStaticMethod(MethodDescriptor.ofMethod(Arc.class, (String)"container", ArcContainer.class, (Class[])new Class[0]), new ResultHandle[0]);
        ResultHandle instanceHandle = creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(ArcContainer.class, (String)"instance", InstanceHandle.class, (Class[])new Class[]{Class.class, Annotation[].class}), arcContainer, new ResultHandle[]{creator.loadClassFromTCCL(repositoryInterface), creator.newArray(Annotation.class, 0)});
        ResultHandle instance = creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(InstanceHandle.class, (String)"get", Object.class, (Class[])new Class[0]), instanceHandle, new ResultHandle[0]);
        creator.ifNull(instance).trueBranch().throwException(RuntimeException.class, repositoryInterface + " instance was not found");
        return instance;
    }
}

