/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.kotlin.serialization.runtime;

import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JvmStreamsKt;
import org.jboss.resteasy.reactive.common.providers.serialisers.JsonMessageBodyWriterUtil;
import org.jboss.resteasy.reactive.server.spi.ServerMessageBodyWriter;
import org.jboss.resteasy.reactive.server.spi.ServerRequestContext;
import org.jetbrains.annotations.NotNull;

@Produces(value={"application/json", "application/*+json", "text/json"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J[\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\b0\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0016\u00a2\u0006\u0002\u0010\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/quarkus/resteasy/reactive/kotlin/serialization/runtime/KotlinSerializationMessageBodyWriter;", "Lorg/jboss/resteasy/reactive/server/spi/ServerMessageBodyWriter$AllWriteableMessageBodyWriter;", "json", "Lkotlinx/serialization/json/Json;", "(Lkotlinx/serialization/json/Json;)V", "writeResponse", "", "o", "", "genericType", "Ljava/lang/reflect/Type;", "context", "Lorg/jboss/resteasy/reactive/server/spi/ServerRequestContext;", "writeTo", "type", "Ljava/lang/Class;", "annotations", "", "", "mediaType", "Ljakarta/ws/rs/core/MediaType;", "httpHeaders", "Ljakarta/ws/rs/core/MultivaluedMap;", "", "entityStream", "Ljava/io/OutputStream;", "(Ljava/lang/Object;Ljava/lang/Class;Ljava/lang/reflect/Type;[Ljava/lang/annotation/Annotation;Ljakarta/ws/rs/core/MediaType;Ljakarta/ws/rs/core/MultivaluedMap;Ljava/io/OutputStream;)V", "NoopCloseAndFlushOutputStream", "quarkus-resteasy-reactive-kotlin-serialization"})
public final class KotlinSerializationMessageBodyWriter
extends ServerMessageBodyWriter.AllWriteableMessageBodyWriter {
    @NotNull
    private final Json json;

    public KotlinSerializationMessageBodyWriter(@NotNull Json json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        this.json = json;
    }

    public void writeTo(@NotNull Object o, @NotNull Class<?> type, @NotNull Type genericType, @NotNull Annotation[] annotations, @NotNull MediaType mediaType, @NotNull MultivaluedMap<String, Object> httpHeaders, @NotNull OutputStream entityStream) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)genericType, (String)"genericType");
        Intrinsics.checkNotNullParameter((Object)annotations, (String)"annotations");
        Intrinsics.checkNotNullParameter((Object)mediaType, (String)"mediaType");
        Intrinsics.checkNotNullParameter(httpHeaders, (String)"httpHeaders");
        Intrinsics.checkNotNullParameter((Object)entityStream, (String)"entityStream");
        JsonMessageBodyWriterUtil.setContentTypeIfNecessary(httpHeaders);
        if (o instanceof String) {
            String string = (String)o;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            entityStream.write(byArray);
        } else {
            JvmStreamsKt.encodeToStream((Json)this.json, (SerializationStrategy)((SerializationStrategy)SerializersKt.serializer((Type)genericType)), (Object)o, (OutputStream)entityStream);
        }
    }

    public void writeResponse(@NotNull Object o, @NotNull Type genericType, @NotNull ServerRequestContext context) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        Intrinsics.checkNotNullParameter((Object)genericType, (String)"genericType");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        OutputStream originalStream = context.getOrCreateOutputStream();
        Intrinsics.checkNotNull((Object)originalStream);
        OutputStream stream = new NoopCloseAndFlushOutputStream(originalStream);
        if (o instanceof String) {
            String string = (String)o;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            stream.write(byArray);
        } else {
            JvmStreamsKt.encodeToStream((Json)this.json, (SerializationStrategy)((SerializationStrategy)SerializersKt.serializer((Type)genericType)), (Object)o, (OutputStream)stream);
        }
        originalStream.close();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/quarkus/resteasy/reactive/kotlin/serialization/runtime/KotlinSerializationMessageBodyWriter$NoopCloseAndFlushOutputStream;", "Ljava/io/OutputStream;", "delegate", "(Ljava/io/OutputStream;)V", "close", "", "flush", "write", "b", "", "off", "", "len", "quarkus-resteasy-reactive-kotlin-serialization"})
    private static final class NoopCloseAndFlushOutputStream
    extends OutputStream {
        @NotNull
        private final OutputStream delegate;

        public NoopCloseAndFlushOutputStream(@NotNull OutputStream delegate) {
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            this.delegate = delegate;
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }

        @Override
        public void write(int b) {
            this.delegate.write(b);
        }

        @Override
        public void write(@NotNull byte[] b) {
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            this.delegate.write(b);
        }

        @Override
        public void write(@NotNull byte[] b, int off, int len) {
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            this.delegate.write(b, off, len);
        }
    }
}

