/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.client.reactive.runtime;

import io.quarkus.rest.client.reactive.runtime.ClientUseWorkerExecutorRestHandler;
import io.quarkus.rest.client.reactive.runtime.RestClientRecorder;
import io.quarkus.rest.client.reactive.runtime.ResteasyReactiveResponseExceptionMapper;
import io.vertx.core.Context;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientResponseContext;
import jakarta.ws.rs.client.ClientResponseFilter;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.microprofile.rest.client.ext.ResponseExceptionMapper;
import org.jboss.resteasy.reactive.client.handlers.ClientResponseCompleteRestHandler;
import org.jboss.resteasy.reactive.client.impl.ClientRequestContextImpl;
import org.jboss.resteasy.reactive.client.impl.RestClientRequestContext;
import org.jboss.resteasy.reactive.client.spi.ClientRestHandler;
import org.jboss.resteasy.reactive.common.core.UnwrappableException;
import org.jboss.resteasy.reactive.common.jaxrs.ResponseImpl;
import org.jboss.resteasy.reactive.spi.RestHandler;

public class MicroProfileRestClientResponseFilter
implements ClientResponseFilter {
    private static final ClientRestHandler[] EMPTY_CLIENT_REST_HANDLERS = new ClientRestHandler[0];
    private final List<ResponseExceptionMapper<?>> exceptionMappers;

    public MicroProfileRestClientResponseFilter(List<ResponseExceptionMapper<?>> exceptionMappers) {
        if (exceptionMappers == null) {
            throw new NullPointerException("exceptionMappers cannot be null");
        }
        this.exceptionMappers = exceptionMappers;
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        for (ResponseExceptionMapper<?> exceptionMapper : this.exceptionMappers) {
            if (!exceptionMapper.handles(responseContext.getStatus(), responseContext.getHeaders())) continue;
            RestClientRequestContext restClientContext = ((ClientRequestContextImpl)requestContext).getRestClientRequestContext();
            boolean requiresBlocking = RestClientRecorder.isClassBlocking(exceptionMapper.getClass());
            if (Context.isOnEventLoopThread() && requiresBlocking) {
                this.switchToWorkerThreadPoolAndRetry(restClientContext);
                break;
            }
            ResponseImpl response = ClientResponseCompleteRestHandler.mapToResponse((RestClientRequestContext)restClientContext, (boolean)false);
            Throwable throwable = exceptionMapper instanceof ResteasyReactiveResponseExceptionMapper ? ((ResteasyReactiveResponseExceptionMapper)exceptionMapper).toThrowable((Response)response, restClientContext) : exceptionMapper.toThrowable((Response)response);
            requestContext.setProperty("io.quarkus.rest.client.invokedExceptionMapperClass", (Object)exceptionMapper.getClass().getName());
            if (throwable == null) continue;
            throw new UnwrappableException(throwable);
        }
    }

    private void switchToWorkerThreadPoolAndRetry(RestClientRequestContext restClientContext) {
        int position;
        ArrayList<ClientRestHandler> nextHandlers = new ArrayList<ClientRestHandler>(2 + ((ClientRestHandler[])restClientContext.getHandlers()).length - position);
        nextHandlers.add(new ClientUseWorkerExecutorRestHandler());
        nextHandlers.add(this.currentHandler(restClientContext));
        for (position = restClientContext.getPosition(); position < ((ClientRestHandler[])restClientContext.getHandlers()).length; ++position) {
            nextHandlers.add(((ClientRestHandler[])restClientContext.getHandlers())[position]);
        }
        restClientContext.restart((RestHandler[])nextHandlers.toArray(EMPTY_CLIENT_REST_HANDLERS), true);
    }

    private ClientRestHandler currentHandler(RestClientRequestContext restClientContext) {
        return ((ClientRestHandler[])restClientContext.getHandlers())[restClientContext.getPosition() - 1];
    }
}

