/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.RedisDataSource;
import io.quarkus.redis.datasource.cuckoo.CfInsertArgs;
import io.quarkus.redis.datasource.cuckoo.CfReserveArgs;
import io.quarkus.redis.datasource.cuckoo.CuckooCommands;
import io.quarkus.redis.datasource.cuckoo.ReactiveCuckooCommands;
import io.quarkus.redis.runtime.datasource.AbstractRedisCommandGroup;
import java.time.Duration;
import java.util.List;

public class BlockingCuckooCommandsImpl<K, V>
extends AbstractRedisCommandGroup
implements CuckooCommands<K, V> {
    private final ReactiveCuckooCommands<K, V> reactive;

    public BlockingCuckooCommandsImpl(RedisDataSource ds, ReactiveCuckooCommands<K, V> reactive, Duration timeout) {
        super(ds, timeout);
        this.reactive = reactive;
    }

    @Override
    public void cfadd(K key, V value) {
        this.reactive.cfadd(key, value).await().atMost(this.timeout);
    }

    @Override
    public boolean cfaddnx(K key, V value) {
        return (Boolean)this.reactive.cfaddnx(key, value).await().atMost(this.timeout);
    }

    @Override
    public long cfcount(K key, V value) {
        return (Long)this.reactive.cfcount(key, value).await().atMost(this.timeout);
    }

    @Override
    public boolean cfdel(K key, V value) {
        return (Boolean)this.reactive.cfdel(key, value).await().atMost(this.timeout);
    }

    @Override
    public boolean cfexists(K key, V value) {
        return (Boolean)this.reactive.cfexists(key, value).await().atMost(this.timeout);
    }

    @Override
    public void cfinsert(K key, V ... values) {
        this.reactive.cfinsert(key, values).await().atMost(this.timeout);
    }

    @Override
    public void cfinsert(K key, CfInsertArgs args, V ... values) {
        this.reactive.cfinsert(key, args, values).await().atMost(this.timeout);
    }

    @Override
    public List<Boolean> cfinsertnx(K key, V ... values) {
        return (List)this.reactive.cfinsertnx(key, values).await().atMost(this.timeout);
    }

    @Override
    public List<Boolean> cfinsertnx(K key, CfInsertArgs args, V ... values) {
        return (List)this.reactive.cfinsertnx(key, args, values).await().atMost(this.timeout);
    }

    @Override
    public List<Boolean> cfmexists(K key, V ... values) {
        return (List)this.reactive.cfmexists(key, values).await().atMost(this.timeout);
    }

    @Override
    public void cfreserve(K key, long capacity) {
        this.reactive.cfreserve(key, capacity).await().atMost(this.timeout);
    }

    @Override
    public void cfreserve(K key, long capacity, CfReserveArgs args) {
        this.reactive.cfreserve(key, capacity, args).await().atMost(this.timeout);
    }
}

