/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.stream.StreamRange;
import io.quarkus.redis.datasource.stream.XAddArgs;
import io.quarkus.redis.datasource.stream.XClaimArgs;
import io.quarkus.redis.datasource.stream.XGroupCreateArgs;
import io.quarkus.redis.datasource.stream.XGroupSetIdArgs;
import io.quarkus.redis.datasource.stream.XPendingArgs;
import io.quarkus.redis.datasource.stream.XReadArgs;
import io.quarkus.redis.datasource.stream.XReadGroupArgs;
import io.quarkus.redis.datasource.stream.XTrimArgs;
import io.quarkus.redis.runtime.datasource.AbstractRedisCommands;
import io.quarkus.redis.runtime.datasource.Marshaller;
import io.quarkus.redis.runtime.datasource.RedisCommand;
import io.quarkus.redis.runtime.datasource.RedisCommandExecutor;
import io.quarkus.redis.runtime.datasource.Validation;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.vertx.mutiny.redis.client.Command;
import io.vertx.mutiny.redis.client.Response;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Map;

public class AbstractStreamCommands<K, F, V>
extends AbstractRedisCommands {
    AbstractStreamCommands(RedisCommandExecutor redis, Type k, Type m, Type v) {
        super(redis, new Marshaller(k, m, v));
    }

    Uni<Response> _xack(K key, String group, String ... ids) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull((Object)group, (String)"group");
        Validation.notNullOrEmpty(ids, "ids");
        ParameterValidation.doesNotContainNull((Object[])ids, (String)"ids");
        RedisCommand cmd = RedisCommand.of(Command.XACK).put(this.marshaller.encode(key)).put(group).putAll(ids);
        return this.execute(cmd);
    }

    Uni<Response> _xadd(K key, Map<F, V> payload) {
        return this._xadd(key, new XAddArgs(), payload);
    }

    Uni<Response> _xadd(K key, XAddArgs args, Map<F, V> payload) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull((Object)args, (String)"args");
        ParameterValidation.nonNull(payload, (String)"payload");
        RedisCommand cmd = RedisCommand.of(Command.XADD).put(this.marshaller.encode(key)).putArgs(args);
        for (Map.Entry<F, V> entry : payload.entrySet()) {
            cmd.put(this.marshaller.encode(entry.getKey()));
            cmd.putNullable(this.marshaller.encode(entry.getValue()));
        }
        return this.execute(cmd);
    }

    Uni<Response> _xautoclaim(K key, String group, String consumer, Duration minIdleTime, String start, int count) {
        ParameterValidation.nonNull(key, (String)"key");
        Validation.notNullOrBlank(group, "group");
        Validation.notNullOrBlank(consumer, "consumer");
        Validation.validateTimeout(minIdleTime, "minIdleTime");
        Validation.notNullOrBlank(start, "start");
        Validation.positive(count, "count");
        RedisCommand cmd = RedisCommand.of(Command.XAUTOCLAIM).put(this.marshaller.encode(key)).put(group).put(consumer).put(minIdleTime.toMillis()).put(start).put("COUNT").put(count);
        return this.execute(cmd);
    }

    Uni<Response> _xautoclaim(K key, String group, String consumer, Duration minIdleTime, String start) {
        ParameterValidation.nonNull(key, (String)"key");
        Validation.notNullOrBlank(group, "group");
        Validation.notNullOrBlank(consumer, "consumer");
        Validation.validateTimeout(minIdleTime, "minIdleTime");
        Validation.notNullOrBlank(start, "start");
        RedisCommand cmd = RedisCommand.of(Command.XAUTOCLAIM).put(this.marshaller.encode(key)).put(group).put(consumer).put(minIdleTime.toMillis()).put(start);
        return this.execute(cmd);
    }

    Uni<Response> _xautoclaim(K key, String group, String consumer, Duration minIdleTime, String start, int count, boolean justId) {
        ParameterValidation.nonNull(key, (String)"key");
        Validation.notNullOrBlank(group, "group");
        Validation.notNullOrBlank(consumer, "consumer");
        Validation.validateTimeout(minIdleTime, "minIdleTime");
        Validation.notNullOrBlank(start, "start");
        Validation.positive(count, "count");
        RedisCommand cmd = RedisCommand.of(Command.XAUTOCLAIM).put(this.marshaller.encode(key)).put(group).put(consumer).put(minIdleTime.toMillis()).put(start);
        if (count > 0) {
            cmd.put("COUNT").put(count);
        }
        if (justId) {
            cmd.put("JUSTID");
        }
        return this.execute(cmd);
    }

    Uni<Response> _xclaim(K key, String group, String consumer, Duration minIdleTime, String ... id) {
        ParameterValidation.nonNull(key, (String)"key");
        Validation.notNullOrBlank(group, "group");
        Validation.notNullOrBlank(consumer, "consumer");
        Validation.validateTimeout(minIdleTime, "minIdleTime");
        Validation.notNullOrEmpty(id, "id");
        ParameterValidation.doesNotContainNull((Object[])id, (String)"id");
        RedisCommand cmd = RedisCommand.of(Command.XCLAIM).put(this.marshaller.encode(key)).put(group).put(consumer).put(Long.toString(minIdleTime.toMillis())).putAll(id);
        return this.execute(cmd);
    }

    Uni<Response> _xclaim(K key, String group, String consumer, Duration minIdleTime, XClaimArgs args, String ... id) {
        ParameterValidation.nonNull(key, (String)"key");
        Validation.notNullOrBlank(group, "group");
        Validation.notNullOrBlank(consumer, "consumer");
        Validation.validateTimeout(minIdleTime, "minIdleTime");
        ParameterValidation.nonNull((Object)args, (String)"args");
        Validation.notNullOrEmpty(id, "id");
        ParameterValidation.doesNotContainNull((Object[])id, (String)"id");
        RedisCommand cmd = RedisCommand.of(Command.XCLAIM).put(this.marshaller.encode(key)).put(group).put(consumer).put(Long.toString(minIdleTime.toMillis())).putAll(id).putArgs(args);
        return this.execute(cmd);
    }

    Uni<Response> _xdel(K key, String ... id) {
        ParameterValidation.nonNull(key, (String)"key");
        Validation.notNullOrEmpty(id, "id");
        ParameterValidation.doesNotContainNull((Object[])id, (String)"id");
        RedisCommand cmd = RedisCommand.of(Command.XDEL).put(this.marshaller.encode(key)).putAll(id);
        return this.execute(cmd);
    }

    Uni<Response> _xgroupCreate(K key, String groupname, String from) {
        ParameterValidation.nonNull(key, (String)"key");
        Validation.notNullOrBlank(groupname, "groupname");
        Validation.notNullOrBlank(from, "from");
        RedisCommand cmd = RedisCommand.of(Command.XGROUP).put("CREATE").put(this.marshaller.encode(key)).put(groupname).put(from);
        return this.execute(cmd);
    }

    Uni<Response> _xgroupCreate(K key, String groupname, String from, XGroupCreateArgs args) {
        ParameterValidation.nonNull(key, (String)"key");
        Validation.notNullOrBlank(groupname, "groupname");
        Validation.notNullOrBlank(from, "from");
        ParameterValidation.nonNull((Object)args, (String)"args");
        RedisCommand cmd = RedisCommand.of(Command.XGROUP).put("CREATE").put(this.marshaller.encode(key)).put(groupname).put(from).putArgs(args);
        return this.execute(cmd);
    }

    Uni<Response> _xgroupCreateConsumer(K key, String groupname, String consumername) {
        ParameterValidation.nonNull(key, (String)"key");
        Validation.notNullOrBlank(groupname, "groupname");
        Validation.notNullOrBlank(consumername, "consumername");
        RedisCommand cmd = RedisCommand.of(Command.XGROUP).put("CREATECONSUMER").put(this.marshaller.encode(key)).put(groupname).put(consumername);
        return this.execute(cmd);
    }

    Uni<Response> _xgroupDelConsumer(K key, String groupname, String consumername) {
        ParameterValidation.nonNull(key, (String)"key");
        Validation.notNullOrBlank(groupname, "groupname");
        Validation.notNullOrBlank(consumername, "consumername");
        RedisCommand cmd = RedisCommand.of(Command.XGROUP).put("DELCONSUMER").put(this.marshaller.encode(key)).put(groupname).put(consumername);
        return this.execute(cmd);
    }

    Uni<Response> _xgroupDestroy(K key, String groupname) {
        ParameterValidation.nonNull(key, (String)"key");
        Validation.notNullOrBlank(groupname, "groupname");
        RedisCommand cmd = RedisCommand.of(Command.XGROUP).put("DESTROY").put(this.marshaller.encode(key)).put(groupname);
        return this.execute(cmd);
    }

    Uni<Response> _xgroupSetId(K key, String groupname, String from) {
        ParameterValidation.nonNull(key, (String)"key");
        Validation.notNullOrBlank(groupname, "groupname");
        Validation.notNullOrBlank(from, "from");
        RedisCommand cmd = RedisCommand.of(Command.XGROUP).put("SETID").put(this.marshaller.encode(key)).put(groupname).put(from);
        return this.execute(cmd);
    }

    Uni<Response> _xgroupSetId(K key, String groupname, String from, XGroupSetIdArgs args) {
        ParameterValidation.nonNull(key, (String)"key");
        Validation.notNullOrBlank(groupname, "groupname");
        Validation.notNullOrBlank(from, "from");
        ParameterValidation.nonNull((Object)args, (String)"args");
        RedisCommand cmd = RedisCommand.of(Command.XGROUP).put("SETID").put(this.marshaller.encode(key)).put(groupname).put(from).putArgs(args);
        return this.execute(cmd);
    }

    Uni<Response> _xlen(K key) {
        ParameterValidation.nonNull(key, (String)"key");
        RedisCommand cmd = RedisCommand.of(Command.XLEN).put(this.marshaller.encode(key));
        return this.execute(cmd);
    }

    Uni<Response> _xrange(K key, StreamRange range, int count) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull((Object)range, (String)"range");
        Validation.positive(count, "count");
        RedisCommand cmd = RedisCommand.of(Command.XRANGE).put(this.marshaller.encode(key)).putArgs(range).put("COUNT").put(count);
        return this.execute(cmd);
    }

    Uni<Response> _xrange(K key, StreamRange range) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull((Object)range, (String)"range");
        RedisCommand cmd = RedisCommand.of(Command.XRANGE).put(this.marshaller.encode(key)).putArgs(range);
        return this.execute(cmd);
    }

    Uni<Response> _xread(K key, String id) {
        ParameterValidation.nonNull(key, (String)"key");
        Validation.notNullOrBlank(id, "id");
        RedisCommand cmd = RedisCommand.of(Command.XREAD).put("STREAMS").put(this.marshaller.encode(key)).put(id);
        return this.execute(cmd);
    }

    Uni<Response> _xread(Map<K, String> lastIdsPerStream) {
        ParameterValidation.nonNull(lastIdsPerStream, (String)"lastIdsPerStream");
        RedisCommand cmd = RedisCommand.of(Command.XREAD).put("STREAMS");
        this.writeStreamsAndIds(lastIdsPerStream, cmd);
        return this.execute(cmd);
    }

    Uni<Response> _xread(K key, String id, XReadArgs args) {
        ParameterValidation.nonNull(key, (String)"key");
        Validation.notNullOrBlank(id, "id");
        ParameterValidation.nonNull((Object)args, (String)"args");
        RedisCommand cmd = RedisCommand.of(Command.XREAD).putArgs(args).put("STREAMS").put(this.marshaller.encode(key)).put(id);
        return this.execute(cmd);
    }

    Uni<Response> _xread(Map<K, String> lastIdsPerStream, XReadArgs args) {
        ParameterValidation.nonNull((Object)args, (String)"args");
        RedisCommand cmd = RedisCommand.of(Command.XREAD).putArgs(args).put("STREAMS");
        this.writeStreamsAndIds(lastIdsPerStream, cmd);
        return this.execute(cmd);
    }

    private void writeStreamsAndIds(Map<K, String> lastIdsPerStream, RedisCommand cmd) {
        ArrayList<String> ids = new ArrayList<String>();
        for (Map.Entry<K, String> entry : lastIdsPerStream.entrySet()) {
            cmd.put(this.marshaller.encode(entry.getKey()));
            ids.add(entry.getValue());
        }
        cmd.putAll(ids);
    }

    Uni<Response> _xreadgroup(String group, String consumer, K key, String id) {
        Validation.notNullOrBlank(group, "group");
        Validation.notNullOrBlank(consumer, "consumer");
        ParameterValidation.nonNull(key, (String)"key");
        Validation.notNullOrBlank(id, "id");
        RedisCommand cmd = RedisCommand.of(Command.XREADGROUP).put("GROUP").put(group).put(consumer).put("STREAMS").put(this.marshaller.encode(key)).put(id);
        return this.execute(cmd);
    }

    Uni<Response> _xreadgroup(String group, String consumer, Map<K, String> lastIdsPerStream) {
        Validation.notNullOrBlank(group, "group");
        Validation.notNullOrBlank(consumer, "consumer");
        ParameterValidation.nonNull(lastIdsPerStream, (String)"lastIdsPerStream");
        RedisCommand cmd = RedisCommand.of(Command.XREADGROUP).put("GROUP").put(group).put(consumer).put("STREAMS");
        this.writeStreamsAndIds(lastIdsPerStream, cmd);
        return this.execute(cmd);
    }

    Uni<Response> _xreadgroup(String group, String consumer, K key, String id, XReadGroupArgs args) {
        Validation.notNullOrBlank(group, "group");
        Validation.notNullOrBlank(consumer, "consumer");
        ParameterValidation.nonNull(key, (String)"key");
        Validation.notNullOrBlank(id, "id");
        ParameterValidation.nonNull((Object)args, (String)"args");
        RedisCommand cmd = RedisCommand.of(Command.XREADGROUP).put("GROUP").put(group).put(consumer).putArgs(args).put("STREAMS").put(this.marshaller.encode(key)).put(id);
        return this.execute(cmd);
    }

    Uni<Response> _xreadgroup(String group, String consumer, Map<K, String> lastIdsPerStream, XReadGroupArgs args) {
        Validation.notNullOrBlank(group, "group");
        Validation.notNullOrBlank(consumer, "consumer");
        ParameterValidation.nonNull(lastIdsPerStream, (String)"lastIdsPerStream");
        ParameterValidation.nonNull((Object)args, (String)"args");
        RedisCommand cmd = RedisCommand.of(Command.XREADGROUP).put("GROUP").put(group).put(consumer).putArgs(args).put("STREAMS");
        this.writeStreamsAndIds(lastIdsPerStream, cmd);
        return this.execute(cmd);
    }

    Uni<Response> _xrevrange(K key, StreamRange range, int count) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull((Object)range, (String)"range");
        Validation.positive(count, "count");
        RedisCommand cmd = RedisCommand.of(Command.XREVRANGE).put(this.marshaller.encode(key)).putArgs(range).put("COUNT").put(count);
        return this.execute(cmd);
    }

    Uni<Response> _xrevrange(K key, StreamRange range) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull((Object)range, (String)"range");
        RedisCommand cmd = RedisCommand.of(Command.XREVRANGE).put(this.marshaller.encode(key)).putArgs(range);
        return this.execute(cmd);
    }

    Uni<Response> _xtrim(K key, XTrimArgs args) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull((Object)args, (String)"args");
        RedisCommand cmd = RedisCommand.of(Command.XTRIM).put(this.marshaller.encode(key)).putArgs(args);
        return this.execute(cmd);
    }

    Uni<Response> _xpending(K key, String group) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(key, (String)"group");
        RedisCommand cmd = RedisCommand.of(Command.XPENDING).put(this.marshaller.encode(key)).put(group);
        return this.execute(cmd);
    }

    Uni<Response> _xpending(K key, String group, StreamRange range, int count, XPendingArgs args) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(key, (String)"group");
        ParameterValidation.nonNull((Object)range, (String)"range");
        Validation.positive(count, "count");
        RedisCommand cmd = RedisCommand.of(Command.XPENDING).put(this.marshaller.encode(key)).put(group);
        if (args != null && args.idle() != null) {
            cmd.put("IDLE");
            cmd.put(args.idle().toMillis());
        }
        cmd.putArgs(range).put(count);
        if (args != null) {
            cmd.putArgs(args);
        }
        return this.execute(cmd);
    }
}

