/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.ReactiveRedisCommands;
import io.quarkus.redis.datasource.ReactiveRedisDataSource;
import io.quarkus.redis.datasource.autosuggest.GetArgs;
import io.quarkus.redis.datasource.autosuggest.ReactiveAutoSuggestCommands;
import io.quarkus.redis.datasource.autosuggest.Suggestion;
import io.quarkus.redis.runtime.datasource.AbstractAutoSuggestCommands;
import io.quarkus.redis.runtime.datasource.ReactiveRedisDataSourceImpl;
import io.quarkus.redis.runtime.datasource.RedisCommandExecutor;
import io.smallrye.mutiny.Uni;
import io.vertx.mutiny.redis.client.Response;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class ReactiveAutoSuggestCommandsImpl<K>
extends AbstractAutoSuggestCommands<K>
implements ReactiveAutoSuggestCommands<K>,
ReactiveRedisCommands {
    private final ReactiveRedisDataSource reactive;

    public ReactiveAutoSuggestCommandsImpl(ReactiveRedisDataSourceImpl redis, Type k) {
        super((RedisCommandExecutor)redis, k);
        this.reactive = redis;
    }

    @Override
    public ReactiveRedisDataSource getDataSource() {
        return this.reactive;
    }

    @Override
    public Uni<Long> ftSugAdd(K key, String string, double score, boolean increment) {
        return super._ftSugAdd(key, string, score, increment).map(Response::toLong);
    }

    @Override
    public Uni<Boolean> ftSugDel(K key, String string) {
        return super._ftSugDel(key, string).map(Response::toBoolean);
    }

    @Override
    public Uni<List<Suggestion>> ftSugGet(K key, String prefix) {
        return super._ftSugget(key, prefix).map(r -> this.decodeAsListOfSuggestion((Response)r, false));
    }

    @Override
    public Uni<List<Suggestion>> ftSugGet(K key, String prefix, GetArgs args) {
        return super._ftSugget(key, prefix, args).map(r -> this.decodeAsListOfSuggestion((Response)r, args.hasScores()));
    }

    List<Suggestion> decodeAsListOfSuggestion(Response response, boolean hasScores) {
        ArrayList<Suggestion> list = new ArrayList<Suggestion>();
        if (hasScores) {
            String current = null;
            for (Response nested : response) {
                if (current == null) {
                    current = nested.toString();
                    continue;
                }
                list.add(new Suggestion(current, nested.toDouble()));
                current = null;
            }
        } else {
            for (Response nested : response) {
                list.add(new Suggestion(nested.toString()));
            }
        }
        return list;
    }

    @Override
    public Uni<Long> ftSugLen(K key) {
        return super._ftSugLen(key).map(Response::toLong);
    }
}

