/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.bloom.BfInsertArgs;
import io.quarkus.redis.datasource.bloom.BfReserveArgs;
import io.quarkus.redis.runtime.datasource.AbstractRedisCommands;
import io.quarkus.redis.runtime.datasource.Marshaller;
import io.quarkus.redis.runtime.datasource.RedisCommand;
import io.quarkus.redis.runtime.datasource.RedisCommandExecutor;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.vertx.mutiny.redis.client.Command;
import io.vertx.mutiny.redis.client.Response;
import java.lang.reflect.Type;

class AbstractBloomCommands<K, V>
extends AbstractRedisCommands {
    AbstractBloomCommands(RedisCommandExecutor redis, Type k, Type v) {
        super(redis, new Marshaller(k, v));
    }

    Uni<Response> _bfadd(K key, V value) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(value, (String)"value");
        RedisCommand command = RedisCommand.of(Command.BF_ADD).put(this.marshaller.encode(key)).put(this.marshaller.encode(value));
        return this.execute(command);
    }

    Uni<Response> _bfexists(K key, V value) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(value, (String)"value");
        RedisCommand command = RedisCommand.of(Command.BF_EXISTS).put(this.marshaller.encode(key)).put(this.marshaller.encode(value));
        return this.execute(command);
    }

    Uni<Response> _bfmadd(K key, V ... values) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.doesNotContainNull((Object[])values, (String)"values");
        if (values.length == 0) {
            throw new IllegalArgumentException("`values` must contain at least one item");
        }
        RedisCommand command = RedisCommand.of(Command.BF_MADD).put(this.marshaller.encode(key));
        for (V value : values) {
            command.put(this.marshaller.encode(value));
        }
        return this.execute(command);
    }

    Uni<Response> _bfmexists(K key, V ... values) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.doesNotContainNull((Object[])values, (String)"values");
        if (values.length == 0) {
            throw new IllegalArgumentException("`values` must contain at least one item");
        }
        RedisCommand command = RedisCommand.of(Command.BF_MEXISTS).put(this.marshaller.encode(key));
        for (V value : values) {
            command.put(this.marshaller.encode(value));
        }
        return this.execute(command);
    }

    Uni<Response> _bfreserve(K key, double errorRate, long capacity, BfReserveArgs args) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull((Object)args, (String)"args");
        RedisCommand command = RedisCommand.of(Command.BF_RESERVE).put(this.marshaller.encode(key)).put(errorRate).put(capacity).putArgs(args);
        return this.execute(command);
    }

    Uni<Response> _bfinsert(K key, BfInsertArgs args, V ... values) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull((Object)args, (String)"args");
        ParameterValidation.doesNotContainNull((Object[])values, (String)"values");
        if (values.length == 0) {
            throw new IllegalArgumentException("`values` must contain at least one item");
        }
        RedisCommand command = RedisCommand.of(Command.BF_INSERT).put(this.marshaller.encode(key)).putArgs(args);
        command.put("ITEMS");
        for (V value : values) {
            command.put(this.marshaller.encode(value));
        }
        return this.execute(command);
    }
}

