/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.datasource.json;

import io.quarkus.redis.datasource.RedisCommands;
import io.quarkus.redis.datasource.json.JsonSetArgs;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.List;
import java.util.OptionalInt;

public interface JsonCommands<K>
extends RedisCommands {
    public <T> void jsonSet(K var1, String var2, T var3);

    default public <T> void jsonSet(K key, T value) {
        this.jsonSet(key, "$", value);
    }

    public void jsonSet(K var1, String var2, JsonObject var3);

    default public void jsonSet(K key, JsonObject json) {
        this.jsonSet(key, "$", json);
    }

    public void jsonSet(K var1, String var2, JsonObject var3, JsonSetArgs var4);

    public void jsonSet(K var1, String var2, JsonArray var3);

    default public void jsonSet(K key, JsonArray json) {
        this.jsonSet(key, "$", json);
    }

    public void jsonSet(K var1, String var2, JsonArray var3, JsonSetArgs var4);

    public <T> void jsonSet(K var1, String var2, T var3, JsonSetArgs var4);

    public <T> T jsonGet(K var1, Class<T> var2);

    public JsonObject jsonGetObject(K var1);

    public JsonArray jsonGetArray(K var1);

    public JsonArray jsonGet(K var1, String var2);

    public JsonObject jsonGet(K var1, String ... var2);

    public <T> List<Integer> jsonArrAppend(K var1, String var2, T ... var3);

    public <T> List<Integer> jsonArrIndex(K var1, String var2, T var3, int var4, int var5);

    default public <T> List<Integer> jsonArrIndex(K key, String path, T value) {
        return this.jsonArrIndex(key, path, value, 0, 0);
    }

    public <T> List<Integer> jsonArrInsert(K var1, String var2, int var3, T ... var4);

    public List<Integer> jsonArrLen(K var1, String var2);

    default public OptionalInt jsonArrLen(K key) {
        List<Integer> list = this.jsonArrLen(key, null);
        if (list.get(0) == null) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(list.get(0));
    }

    public <T> List<T> jsonArrPop(K var1, Class<T> var2, String var3, int var4);

    default public <T> List<T> jsonArrPop(K key, Class<T> clazz, String path) {
        return this.jsonArrPop(key, clazz, path, -1);
    }

    default public <T> T jsonArrPop(K key, Class<T> clazz) {
        List<T> list = this.jsonArrPop(key, clazz, null, -1);
        return list.get(0);
    }

    public List<Integer> jsonArrTrim(K var1, String var2, int var3, int var4);

    public int jsonClear(K var1, String var2);

    default public int jsonClear(K key) {
        return this.jsonClear(key, null);
    }

    public int jsonDel(K var1, String var2);

    default public int jsonDel(K key) {
        return this.jsonDel(key, null);
    }

    public List<JsonArray> jsonMget(String var1, K ... var2);

    public void jsonNumincrby(K var1, String var2, double var3);

    public List<List<String>> jsonObjKeys(K var1, String var2);

    default public List<String> jsonObjKeys(K key) {
        List<List<String>> lists = this.jsonObjKeys(key, null);
        return lists.get(0);
    }

    public List<Integer> jsonObjLen(K var1, String var2);

    default public OptionalInt jsonObjLen(K key) {
        List<Integer> integers = this.jsonObjLen(key, null);
        if (integers.get(0) == null) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(integers.get(0));
    }

    public List<Integer> jsonStrAppend(K var1, String var2, String var3);

    public List<Integer> jsonStrLen(K var1, String var2);

    public List<Boolean> jsonToggle(K var1, String var2);

    public List<String> jsonType(K var1, String var2);
}

