/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.runtime.devmode;

import io.quarkus.dev.ErrorPageGenerators;
import io.quarkus.dev.spi.HotReplacementContext;
import io.quarkus.dev.spi.HotReplacementSetup;
import io.quarkus.qute.Engine;
import io.quarkus.qute.Escaper;
import io.quarkus.qute.EvalContext;
import io.quarkus.qute.ReflectionValueResolver;
import io.quarkus.qute.Template;
import io.quarkus.qute.ValueResolver;
import io.quarkus.runtime.TemplateHtmlBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

public class QuteErrorPageSetup
implements HotReplacementSetup {
    private static final Logger LOG = Logger.getLogger(QuteErrorPageSetup.class);
    private static final String TEMPLATE_EXCEPTION = "io.quarkus.qute.TemplateException";
    private static final String ORIGIN = "io.quarkus.qute.TemplateNode$Origin";
    private static final String PROBLEM_TEMPLATE = "<h3>#{problemIndex} {title}</h3>\n<div style=\"margin-bottom:0.5em;\">{description}</div>\n<div style=\"font-family:monospace;font-size:1em;background-color:#2E3436;color:white;padding:1em;margin-bottom:2em;\">\n{#if realLines.get(0) > 1}<span style=\"color:silver;\">...</span><br>{/if}\n{#for line in sourceLines}\n{#if lineNumber is realLines.get(line_index)}<div style=\"background-color:#555753;\">{/if}\n<span style=\"color:silver;\">{realLines.get(line_index).pad}</span>\n {line}\n{#if lineNumber is realLines.get(line_index)}</div>{#else}<br>{/if}\n{#if lineNumber is realLines.get(line_index)}{space.pad}<span style=\"color:red;\">{#for i in lineCharacterStart}={/for}^</span><br>{/if}\n{/for}\n{#if endLinesSkipped}<span style=\"color:silver;\">...</span>{/if}\n</div>";
    private HotReplacementContext hotReplacementContext;

    public void setupHotDeployment(HotReplacementContext context) {
        this.hotReplacementContext = context;
        ErrorPageGenerators.register((String)TEMPLATE_EXCEPTION, this::generatePage);
    }

    String generatePage(Throwable exception) {
        Escaper escaper = Escaper.builder().add('\"', "&quot;").add('\'', "&#39;").add('&', "&amp;").add('<', "&lt;").add('>', "&gt;").build();
        Template problemTemplate = Engine.builder().addDefaults().addValueResolver((ValueResolver)new ReflectionValueResolver()).addValueResolver(new ValueResolver(){

            public boolean appliesTo(EvalContext context) {
                return context.getName().equals("pad");
            }

            public CompletionStage<Object> resolve(EvalContext context) {
                return CompletableFuture.completedFuture(QuteErrorPageSetup.htmlPadRight(context.getBase().toString(), 5));
            }
        }).build().parse(PROBLEM_TEMPLATE);
        Throwable[] suppressed = exception.getSuppressed();
        List<Throwable> problems = suppressed.length == 0 ? Collections.singletonList(exception) : Arrays.asList(suppressed);
        String problemsFound = "Found " + problems.size() + " Qute problems";
        TemplateHtmlBuilder builder = new TemplateHtmlBuilder("Error restarting Quarkus", problemsFound, problemsFound);
        problems.sort(new Comparator<Throwable>(){

            @Override
            public int compare(Throwable t1, Throwable t2) {
                Object o2;
                Object o1 = QuteErrorPageSetup.this.getOrigin(t1);
                if (o1 == (o2 = QuteErrorPageSetup.this.getOrigin(t2))) {
                    return 0;
                }
                if (o1 == null && o2 != null) {
                    return -1;
                }
                if (o1 != null && o2 == null) {
                    return 1;
                }
                return Integer.compare(QuteErrorPageSetup.this.getLine(o1), QuteErrorPageSetup.this.getLine(o2));
            }
        });
        ListIterator<Throwable> it = problems.listIterator();
        while (it.hasNext()) {
            Throwable problem = it.next();
            builder.append(this.getProblemInfo(it.previousIndex() + 1, problem, problemTemplate, escaper));
        }
        return builder.toString();
    }

    String getProblemInfo(int index, Throwable problem, Template problemTemplate, Escaper escaper) {
        Object origin = this.getOrigin(problem);
        String[] messageLines = problem.getMessage().split("\\r?\\n");
        if (origin == null) {
            return Arrays.stream(messageLines).collect(Collectors.joining("<br>"));
        }
        String templateId = this.getTemplateId(origin);
        int lineNumber = this.getLine(origin);
        int lineCharacterStart = this.getLineCharacterStart(origin);
        List sourceLines = new ArrayList<String>();
        try (BufferedReader in = this.getBufferedReader(templateId);){
            String line = null;
            while ((line = in.readLine()) != null) {
                sourceLines.add(escaper.escape((CharSequence)line).replace(" ", "&nbsp;"));
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Unable to read the template source: " + templateId), (Throwable)e);
        }
        ArrayList<Integer> realLines = new ArrayList<Integer>();
        boolean endLinesSkipped = false;
        if (sourceLines.size() > 15) {
            int fromIndex = lineNumber > 7 ? lineNumber - 8 : 0;
            int toIndex = lineNumber + 7 > sourceLines.size() ? sourceLines.size() : lineNumber + 7;
            for (int j = fromIndex; j < toIndex; ++j) {
                realLines.add(j + 1);
            }
            endLinesSkipped = toIndex != (sourceLines = sourceLines.subList(fromIndex, toIndex)).size();
        } else {
            for (int j = 0; j < sourceLines.size(); ++j) {
                realLines.add(j + 1);
            }
        }
        return problemTemplate.data("problemIndex", (Object)index).data("title", (Object)messageLines[0]).data("description", (Object)Arrays.stream(messageLines).skip(1L).collect(Collectors.joining("<br>"))).data("sourceLines", sourceLines).data("lineNumber", (Object)lineNumber).data("lineCharacterStart", (Object)lineCharacterStart).data("realLines", realLines).data("endLinesSkipped", (Object)endLinesSkipped).data("space", (Object)" ").render();
    }

    static String htmlPadRight(String s, int n) {
        return String.format("%-" + n + "s", s).replace(" ", "&nbsp;");
    }

    private BufferedReader getBufferedReader(String templateId) throws IOException {
        for (Path resource : this.hotReplacementContext.getResourcesDir()) {
            Path template;
            Path templates = resource.resolve("templates");
            if (!Files.exists(templates, new LinkOption[0]) || !Files.exists(template = templates.resolve(templateId.replace("\\", "/")), new LinkOption[0])) continue;
            return Files.newBufferedReader(template);
        }
        throw new IllegalStateException("Template source not available");
    }

    private Object getOrigin(Throwable t) {
        Object origin = null;
        try {
            Method getOrigin = t.getClass().getClassLoader().loadClass(TEMPLATE_EXCEPTION).getMethod("getOrigin", new Class[0]);
            origin = getOrigin.invoke((Object)t, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LOG.warn((Object)"Unable to read the origin field", (Throwable)e);
        }
        return origin;
    }

    private String getTemplateId(Object origin) {
        String templateId = null;
        try {
            Method getTemplateId = origin.getClass().getClassLoader().loadClass(ORIGIN).getMethod("getTemplateId", new Class[0]);
            templateId = getTemplateId.invoke(origin, new Object[0]).toString();
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LOG.warn((Object)"Unable to invoke the TemplateNode.Origin.getTemplateId() method", (Throwable)e);
        }
        return templateId;
    }

    private int getLine(Object origin) {
        int line = 0;
        try {
            Method getLine = origin.getClass().getClassLoader().loadClass(ORIGIN).getMethod("getLine", new Class[0]);
            line = (Integer)getLine.invoke(origin, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LOG.warn((Object)"Unable to invoke the TemplateNode.Origin.getLine() method", (Throwable)e);
        }
        return line;
    }

    private int getLineCharacterStart(Object origin) {
        int lineCharacter = 0;
        try {
            Method getLineCharacter = origin.getClass().getClassLoader().loadClass(ORIGIN).getMethod("getLineCharacterStart", new Class[0]);
            lineCharacter = (Integer)getLineCharacter.invoke(origin, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LOG.warn((Object)"Unable to invoke the TemplateNode.Origin.getLineCharacterStart() method", (Throwable)e);
        }
        return lineCharacter;
    }
}

