/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.cache.deployment.spi.AdditionalCacheNameBuildItem;
import io.quarkus.cache.deployment.spi.CacheTypeBuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.qute.runtime.cache.CacheConfigurator;
import io.quarkus.qute.runtime.cache.MissingCacheConfigurator;
import io.quarkus.qute.runtime.cache.UnsupportedRemoteCacheConfigurator;
import java.util.Optional;

public class CacheProcessor {
    @BuildStep
    void initialize(Optional<CacheTypeBuildItem> cacheTypeBuildItem, BuildProducer<AdditionalBeanBuildItem> beans, BuildProducer<AdditionalCacheNameBuildItem> cacheNames) {
        Class<MissingCacheConfigurator> configuratorClass;
        boolean supported = false;
        if (cacheTypeBuildItem.isEmpty()) {
            configuratorClass = MissingCacheConfigurator.class;
        } else {
            CacheTypeBuildItem.Type type = cacheTypeBuildItem.get().getType();
            if (type != CacheTypeBuildItem.Type.LOCAL) {
                configuratorClass = UnsupportedRemoteCacheConfigurator.class;
            } else {
                configuratorClass = CacheConfigurator.class;
                supported = true;
            }
        }
        beans.produce((BuildItem)new AdditionalBeanBuildItem(new String[]{configuratorClass.getName()}));
        if (supported) {
            cacheNames.produce((BuildItem)new AdditionalCacheNameBuildItem("qute-cache"));
        }
    }
}

