/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.deployment;

import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.builditem.ApplicationIndexBuildItem;
import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.qute.TemplateGlobal;
import io.quarkus.qute.deployment.TemplatePathBuildItem;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import org.jboss.jandex.DotName;

@BuildSteps(onlyIf={IsDevelopment.class})
public class QuteDevModeProcessor {
    @BuildStep
    void collectGeneratedContents(List<TemplatePathBuildItem> templatePaths, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> errors) {
        HashMap<String, String> contents = new HashMap<String, String>();
        for (TemplatePathBuildItem template : templatePaths) {
            if (template.isFileBased()) continue;
            contents.put(template.getPath(), template.getContent());
        }
        DevConsoleManager.setGlobal((String)"io.quarkus.qute.generatedContents", contents);
    }

    @BuildStep
    void generateTestTemplateGlobal(ApplicationIndexBuildItem applicationIndex, BuildProducer<GeneratedBeanBuildItem> generatedBeanClasses) {
        if (applicationIndex.getIndex().getClassByName(DotName.createSimple((String)"io.quarkus.qute.deployment.devmode.QuteDummyTemplateGlobalMarker")) != null) {
            GeneratedBeanGizmoAdaptor gizmoAdaptor = new GeneratedBeanGizmoAdaptor(generatedBeanClasses, (Predicate)new Predicate<String>(){

                @Override
                public boolean test(String t) {
                    return false;
                }
            });
            try (ClassCreator classCreator = ClassCreator.builder().className("org.acme.qute.test.QuteDummyGlobals").classOutput((ClassOutput)gizmoAdaptor).build();){
                classCreator.addAnnotation(TemplateGlobal.class);
                FieldCreator quteDummyFoo = classCreator.getFieldCreator("quteDummyFoo", String.class);
                quteDummyFoo.setModifiers(8);
                MethodCreator staticInitializer = classCreator.getMethodCreator("<clinit>", Void.TYPE, new Class[0]);
                staticInitializer.setModifiers(8);
                staticInitializer.writeStaticField(quteDummyFoo.getFieldDescriptor(), staticInitializer.load("bar"));
                staticInitializer.returnVoid();
            }
        }
    }
}

