/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.deployment;

import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.qute.Namespaces;
import io.quarkus.qute.generator.ExtensionMethodGenerator;
import java.util.List;
import java.util.regex.Pattern;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public final class TemplateExtensionMethodBuildItem
extends MultiBuildItem {
    private final MethodInfo method;
    private final String matchName;
    private final List<String> matchNames;
    private final String matchRegex;
    private final Pattern matchPattern;
    private final Type matchType;
    private final int priority;
    private final String namespace;
    private final ExtensionMethodGenerator.Parameters params;

    public TemplateExtensionMethodBuildItem(MethodInfo method, String matchName, String matchRegex, Type matchType, int priority, String namespace) {
        this(method, matchName, List.of(), matchRegex, matchType, priority, namespace);
    }

    public TemplateExtensionMethodBuildItem(MethodInfo method, String matchName, List<String> matchNames, String matchRegex, Type matchType, int priority, String namespace) {
        this.method = method;
        this.matchName = matchName;
        this.matchNames = List.copyOf(matchNames);
        this.matchRegex = matchRegex;
        this.matchType = matchType;
        this.priority = priority;
        this.namespace = namespace != null && !namespace.isEmpty() ? Namespaces.requireValid((String)namespace) : namespace;
        this.matchPattern = matchRegex == null || matchRegex.isEmpty() ? null : Pattern.compile(matchRegex);
        this.params = new ExtensionMethodGenerator.Parameters(method, this.matchPattern != null || !matchNames.isEmpty() || this.matchesAny(), this.hasNamespace());
    }

    public MethodInfo getMethod() {
        return this.method;
    }

    public String getMatchName() {
        return this.matchName;
    }

    public List<String> getMatchNames() {
        return this.matchNames;
    }

    public String getMatchRegex() {
        return this.matchRegex;
    }

    public Type getMatchType() {
        return this.matchType;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getNamespace() {
        return this.namespace;
    }

    boolean matchesClass(ClassInfo clazz) {
        return this.matchType.name().equals((Object)clazz.name());
    }

    boolean matchesName(String name) {
        if (this.matchPattern != null) {
            return this.matchPattern.matcher(name).matches();
        }
        if (this.matchNames.isEmpty()) {
            return this.matchesAny() ? true : this.matchName.equals(name);
        }
        return this.matchNames.contains(name);
    }

    boolean matchesAny() {
        return "*".equals(this.matchName);
    }

    public boolean hasNamespace() {
        return this.namespace != null && !this.namespace.isEmpty();
    }

    public ExtensionMethodGenerator.Parameters getParams() {
        return this.params;
    }
}

