/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime.devui;

import io.quarkus.arc.Arc;
import io.quarkus.oidc.AuthorizationCodeTokens;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.runtime.DefaultTokenStateManager;
import io.quarkus.oidc.runtime.OidcConfig;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Handler;
import io.vertx.core.http.Cookie;
import io.vertx.ext.web.RoutingContext;
import java.lang.annotation.Annotation;

final class OidcDevSessionCookieReaderHandler
implements Handler<RoutingContext> {
    private final OidcTenantConfig defaultTenantConfig;

    OidcDevSessionCookieReaderHandler(OidcConfig oidcConfig) {
        this.defaultTenantConfig = OidcTenantConfig.of(OidcConfig.getDefaultTenant(oidcConfig));
    }

    public void handle(RoutingContext rc) {
        Cookie cookie = rc.request().getCookie("q_session");
        if (cookie != null) {
            DefaultTokenStateManager tokenStateManager = (DefaultTokenStateManager)Arc.container().instance(DefaultTokenStateManager.class, new Annotation[0]).get();
            Uni<AuthorizationCodeTokens> tokensUni = tokenStateManager.getTokens(rc, this.defaultTenantConfig, cookie.getValue(), null);
            tokensUni.subscribe().with(tokens -> {
                rc.response().setStatusCode(200);
                rc.response().putHeader("Content-Type", "application/json");
                rc.end("{\"id_token\": \"" + tokens.getIdToken() + "\", \"access_token\": \"" + tokens.getAccessToken() + "\", \"refresh_token\": \"" + tokens.getRefreshToken() + "\"}");
            }, arg_0 -> ((RoutingContext)rc).fail(arg_0));
        } else {
            rc.response().setStatusCode(200);
            rc.response().putHeader("Content-Type", "application/json");
            rc.end("{}");
        }
    }
}

