/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.AuthorizationCodeTokens;
import io.quarkus.oidc.OidcRequestContext;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.TokenStateManager;
import io.quarkus.oidc.runtime.CodeAuthenticationMechanism;
import io.quarkus.oidc.runtime.OidcUtils;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.quarkus.security.AuthenticationFailedException;
import io.smallrye.mutiny.Uni;
import io.vertx.core.http.impl.ServerCookie;
import io.vertx.ext.web.RoutingContext;
import javax.enterprise.context.ApplicationScoped;

@ApplicationScoped
public class DefaultTokenStateManager
implements TokenStateManager {
    private static final String SESSION_AT_COOKIE_NAME = "q_session_at";
    private static final String SESSION_RT_COOKIE_NAME = "q_session_rt";

    @Override
    public Uni<String> createTokenState(RoutingContext routingContext, OidcTenantConfig oidcConfig, AuthorizationCodeTokens tokens, OidcRequestContext<String> requestContext) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.encryptToken(tokens.getIdToken(), routingContext, oidcConfig));
        if (oidcConfig.tokenStateManager.strategy == OidcTenantConfig.TokenStateManager.Strategy.KEEP_ALL_TOKENS) {
            if (!oidcConfig.tokenStateManager.splitTokens) {
                sb.append("|").append(this.encryptToken(tokens.getAccessToken(), routingContext, oidcConfig)).append("|").append(this.encryptToken(tokens.getRefreshToken(), routingContext, oidcConfig));
            } else {
                CodeAuthenticationMechanism.createCookie(routingContext, oidcConfig, DefaultTokenStateManager.getAccessTokenCookieName(oidcConfig), this.encryptToken(tokens.getAccessToken(), routingContext, oidcConfig), (Long)routingContext.get("session-max-age"));
                if (tokens.getRefreshToken() != null) {
                    CodeAuthenticationMechanism.createCookie(routingContext, oidcConfig, DefaultTokenStateManager.getRefreshTokenCookieName(oidcConfig), this.encryptToken(tokens.getRefreshToken(), routingContext, oidcConfig), (Long)routingContext.get("session-max-age"));
                }
            }
        } else if (oidcConfig.tokenStateManager.strategy == OidcTenantConfig.TokenStateManager.Strategy.ID_REFRESH_TOKENS) {
            if (!oidcConfig.tokenStateManager.splitTokens) {
                sb.append("|").append("").append("|").append(this.encryptToken(tokens.getRefreshToken(), routingContext, oidcConfig));
            } else if (tokens.getRefreshToken() != null) {
                CodeAuthenticationMechanism.createCookie(routingContext, oidcConfig, DefaultTokenStateManager.getRefreshTokenCookieName(oidcConfig), this.encryptToken(tokens.getRefreshToken(), routingContext, oidcConfig), (Long)routingContext.get("session-max-age"));
            }
        }
        return Uni.createFrom().item((Object)sb.toString());
    }

    @Override
    public Uni<AuthorizationCodeTokens> getTokens(RoutingContext routingContext, OidcTenantConfig oidcConfig, String tokenState, OidcRequestContext<AuthorizationCodeTokens> requestContext) {
        String[] tokens = CodeAuthenticationMechanism.COOKIE_PATTERN.split(tokenState);
        String idToken = this.decryptToken(tokens[0], routingContext, oidcConfig);
        String accessToken = null;
        String refreshToken = null;
        if (oidcConfig.tokenStateManager.strategy == OidcTenantConfig.TokenStateManager.Strategy.KEEP_ALL_TOKENS) {
            if (!oidcConfig.tokenStateManager.splitTokens) {
                accessToken = this.decryptToken(tokens[1], routingContext, oidcConfig);
                refreshToken = this.decryptToken(tokens[2], routingContext, oidcConfig);
            } else {
                ServerCookie rtCookie;
                ServerCookie atCookie = DefaultTokenStateManager.getAccessTokenCookie(routingContext, oidcConfig);
                if (atCookie != null) {
                    accessToken = this.decryptToken(atCookie.getValue(), routingContext, oidcConfig);
                }
                if ((rtCookie = DefaultTokenStateManager.getRefreshTokenCookie(routingContext, oidcConfig)) != null) {
                    refreshToken = this.decryptToken(rtCookie.getValue(), routingContext, oidcConfig);
                }
            }
        } else if (oidcConfig.tokenStateManager.strategy == OidcTenantConfig.TokenStateManager.Strategy.ID_REFRESH_TOKENS) {
            if (!oidcConfig.tokenStateManager.splitTokens) {
                refreshToken = this.decryptToken(tokens[2], routingContext, oidcConfig);
            } else {
                ServerCookie rtCookie = DefaultTokenStateManager.getRefreshTokenCookie(routingContext, oidcConfig);
                if (rtCookie != null) {
                    refreshToken = this.decryptToken(rtCookie.getValue(), routingContext, oidcConfig);
                }
            }
        }
        return Uni.createFrom().item((Object)new AuthorizationCodeTokens(idToken, accessToken, refreshToken));
    }

    @Override
    public Uni<Void> deleteTokens(RoutingContext routingContext, OidcTenantConfig oidcConfig, String tokenState, OidcRequestContext<Void> requestContext) {
        if (oidcConfig.tokenStateManager.splitTokens) {
            OidcUtils.removeCookie(routingContext, DefaultTokenStateManager.getAccessTokenCookie(routingContext, oidcConfig), oidcConfig);
            OidcUtils.removeCookie(routingContext, DefaultTokenStateManager.getRefreshTokenCookie(routingContext, oidcConfig), oidcConfig);
        }
        return CodeAuthenticationMechanism.VOID_UNI;
    }

    private static ServerCookie getAccessTokenCookie(RoutingContext routingContext, OidcTenantConfig oidcConfig) {
        return (ServerCookie)routingContext.request().getCookie(DefaultTokenStateManager.getAccessTokenCookieName(oidcConfig));
    }

    private static ServerCookie getRefreshTokenCookie(RoutingContext routingContext, OidcTenantConfig oidcConfig) {
        return (ServerCookie)routingContext.request().getCookie(DefaultTokenStateManager.getRefreshTokenCookieName(oidcConfig));
    }

    private static String getAccessTokenCookieName(OidcTenantConfig oidcConfig) {
        String cookieSuffix = CodeAuthenticationMechanism.getCookieSuffix(oidcConfig);
        return SESSION_AT_COOKIE_NAME + cookieSuffix;
    }

    private static String getRefreshTokenCookieName(OidcTenantConfig oidcConfig) {
        String cookieSuffix = CodeAuthenticationMechanism.getCookieSuffix(oidcConfig);
        return SESSION_RT_COOKIE_NAME + cookieSuffix;
    }

    private String encryptToken(String token, RoutingContext context, OidcTenantConfig oidcConfig) {
        if (oidcConfig.tokenStateManager.encryptionRequired.orElse(false).booleanValue()) {
            TenantConfigContext configContext = (TenantConfigContext)context.get(TenantConfigContext.class.getName());
            try {
                return OidcUtils.encryptString(token, configContext.getTokenEncSecretKey());
            }
            catch (Exception ex) {
                throw new AuthenticationFailedException((Throwable)ex);
            }
        }
        return token;
    }

    private String decryptToken(String token, RoutingContext context, OidcTenantConfig oidcConfig) {
        if (oidcConfig.tokenStateManager.encryptionRequired.orElse(false).booleanValue()) {
            TenantConfigContext configContext = (TenantConfigContext)context.get(TenantConfigContext.class.getName());
            try {
                return OidcUtils.decryptString(token, configContext.getTokenEncSecretKey());
            }
            catch (Exception ex) {
                throw new AuthenticationFailedException((Throwable)ex);
            }
        }
        return token;
    }
}

