/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc;

import io.quarkus.oidc.common.runtime.OidcCommonConfig;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;

@ConfigGroup
public class OidcTenantConfig
extends OidcCommonConfig {
    @ConfigItem
    public Optional<String> tenantId = Optional.empty();
    @ConfigItem(defaultValue="true")
    public boolean tenantEnabled = true;
    @ConfigItem(defaultValueDocumentation="service")
    public Optional<ApplicationType> applicationType = Optional.empty();
    @ConfigItem
    public Optional<String> authorizationPath = Optional.empty();
    @ConfigItem
    public Optional<String> userInfoPath = Optional.empty();
    @ConfigItem
    public Optional<String> introspectionPath = Optional.empty();
    @ConfigItem
    public Optional<String> jwksPath = Optional.empty();
    @ConfigItem
    public Optional<String> endSessionPath = Optional.empty();
    @ConfigItem
    public Optional<String> publicKey = Optional.empty();
    @ConfigItem
    public IntrospectionCredentials introspectionCredentials = new IntrospectionCredentials();
    @ConfigItem
    public Roles roles = new Roles();
    @ConfigItem
    public Token token = new Token();
    @ConfigItem
    public Logout logout = new Logout();
    public Authentication authentication = new Authentication();
    public CodeGrant codeGrant = new CodeGrant();
    @ConfigItem
    public TokenStateManager tokenStateManager = new TokenStateManager();
    @ConfigItem(defaultValue="true")
    public boolean allowTokenIntrospectionCache = true;
    @ConfigItem(defaultValue="true")
    public boolean allowUserInfoCache = true;
    @ConfigItem(defaultValue="false")
    public boolean cacheUserInfoInIdtoken = false;
    @ConfigItem
    public Optional<Provider> provider = Optional.empty();

    public Optional<String> getAuthorizationPath() {
        return this.authorizationPath;
    }

    public void setAuthorizationPath(String authorizationPath) {
        this.authorizationPath = Optional.of(authorizationPath);
    }

    public Optional<String> getUserInfoPath() {
        return this.userInfoPath;
    }

    public void setUserInfoPath(String userInfoPath) {
        this.userInfoPath = Optional.of(userInfoPath);
    }

    public Optional<String> getIntrospectionPath() {
        return this.introspectionPath;
    }

    public void setIntrospectionPath(String introspectionPath) {
        this.introspectionPath = Optional.of(introspectionPath);
    }

    public Optional<String> getJwksPath() {
        return this.jwksPath;
    }

    public void setJwksPath(String jwksPath) {
        this.jwksPath = Optional.of(jwksPath);
    }

    public Optional<String> getEndSessionPath() {
        return this.endSessionPath;
    }

    public void setEndSessionPath(String endSessionPath) {
        this.endSessionPath = Optional.of(endSessionPath);
    }

    public Optional<String> getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = Optional.of(publicKey);
    }

    public Roles getRoles() {
        return this.roles;
    }

    public void setRoles(Roles roles) {
        this.roles = roles;
    }

    public Token getToken() {
        return this.token;
    }

    public void setToken(Token token) {
        this.token = token;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    public Optional<String> getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = Optional.of(tenantId);
    }

    public boolean isTenantEnabled() {
        return this.tenantEnabled;
    }

    public void setTenantEnabled(boolean enabled) {
        this.tenantEnabled = enabled;
    }

    public void setLogout(Logout logout) {
        this.logout = logout;
    }

    public Logout getLogout() {
        return this.logout;
    }

    public Optional<Provider> getProvider() {
        return this.provider;
    }

    public void setProvider(Provider provider) {
        this.provider = Optional.of(provider);
    }

    public Optional<ApplicationType> getApplicationType() {
        return this.applicationType;
    }

    public void setApplicationType(ApplicationType type) {
        this.applicationType = Optional.of(type);
    }

    public boolean isAllowTokenIntrospectionCache() {
        return this.allowTokenIntrospectionCache;
    }

    public void setAllowTokenIntrospectionCache(boolean allowTokenIntrospectionCache) {
        this.allowTokenIntrospectionCache = allowTokenIntrospectionCache;
    }

    public boolean isAllowUserInfoCache() {
        return this.allowUserInfoCache;
    }

    public void setAllowUserInfoCache(boolean allowUserInfoCache) {
        this.allowUserInfoCache = allowUserInfoCache;
    }

    public boolean isCacheUserInfoInIdtoken() {
        return this.cacheUserInfoInIdtoken;
    }

    public void setCacheUserInfoInIdtoken(boolean cacheUserInfoInIdtoken) {
        this.cacheUserInfoInIdtoken = cacheUserInfoInIdtoken;
    }

    public IntrospectionCredentials getIntrospectionCredentials() {
        return this.introspectionCredentials;
    }

    public void setIntrospectionCredentials(IntrospectionCredentials introspectionCredentials) {
        this.introspectionCredentials = introspectionCredentials;
    }

    public CodeGrant getCodeGrant() {
        return this.codeGrant;
    }

    public void setCodeGrant(CodeGrant codeGrant) {
        this.codeGrant = codeGrant;
    }

    public static enum Provider {
        APPLE,
        FACEBOOK,
        GITHUB,
        GOOGLE,
        MICROSOFT,
        SPOTIFY,
        TWITTER;

    }

    public static enum ApplicationType {
        WEB_APP,
        SERVICE,
        HYBRID;

    }

    @ConfigGroup
    public static class Token {
        @ConfigItem
        public Optional<String> issuer = Optional.empty();
        @ConfigItem
        public Optional<List<String>> audience = Optional.empty();
        @ConfigItem
        public Map<String, String> requiredClaims = new HashMap<String, String>();
        @ConfigItem
        public Optional<String> tokenType = Optional.empty();
        @ConfigItem
        public OptionalInt lifespanGrace = OptionalInt.empty();
        @ConfigItem
        public Optional<Duration> age = Optional.empty();
        @ConfigItem
        public Optional<String> principalClaim = Optional.empty();
        @ConfigItem
        public boolean refreshExpired;
        @ConfigItem
        public Optional<Duration> refreshTokenTimeSkew = Optional.empty();
        @ConfigItem(defaultValue="10M")
        public Duration forcedJwkRefreshInterval = Duration.ofMinutes(10L);
        @ConfigItem
        public Optional<String> header = Optional.empty();
        @ConfigItem
        public Optional<String> decryptionKeyLocation = Optional.empty();
        @ConfigItem(defaultValue="true")
        public boolean allowJwtIntrospection = true;
        @ConfigItem(defaultValue="false")
        public boolean requireJwtIntrospectionOnly = false;
        @ConfigItem(defaultValue="true")
        public boolean allowOpaqueTokenIntrospection = true;

        public static Token fromIssuer(String issuer) {
            Token tokenClaims = new Token();
            tokenClaims.issuer = Optional.of(issuer);
            tokenClaims.audience = Optional.ofNullable(null);
            return tokenClaims;
        }

        public static Token fromAudience(String ... audience) {
            Token tokenClaims = new Token();
            tokenClaims.issuer = Optional.ofNullable(null);
            tokenClaims.audience = Optional.of(Arrays.asList(audience));
            return tokenClaims;
        }

        public Optional<String> getIssuer() {
            return this.issuer;
        }

        public void setIssuer(String issuer) {
            this.issuer = Optional.of(issuer);
        }

        public Optional<String> getHeader() {
            return this.header;
        }

        public void setHeader(String header) {
            this.header = Optional.of(header);
        }

        public Optional<List<String>> getAudience() {
            return this.audience;
        }

        public void setAudience(List<String> audience) {
            this.audience = Optional.of(audience);
        }

        public OptionalInt getLifespanGrace() {
            return this.lifespanGrace;
        }

        public void setLifespanGrace(int lifespanGrace) {
            this.lifespanGrace = OptionalInt.of(lifespanGrace);
        }

        public Optional<String> getPrincipalClaim() {
            return this.principalClaim;
        }

        public void setPrincipalClaim(String principalClaim) {
            this.principalClaim = Optional.of(principalClaim);
        }

        public boolean isRefreshExpired() {
            return this.refreshExpired;
        }

        public void setRefreshExpired(boolean refreshExpired) {
            this.refreshExpired = refreshExpired;
        }

        public Duration getForcedJwkRefreshInterval() {
            return this.forcedJwkRefreshInterval;
        }

        public void setForcedJwkRefreshInterval(Duration forcedJwkRefreshInterval) {
            this.forcedJwkRefreshInterval = forcedJwkRefreshInterval;
        }

        public Optional<String> getTokenType() {
            return this.tokenType;
        }

        public void setTokenType(String tokenType) {
            this.tokenType = Optional.of(tokenType);
        }

        public Optional<Duration> getRefreshTokenTimeSkew() {
            return this.refreshTokenTimeSkew;
        }

        public void setRefreshTokenTimeSkew(Duration refreshTokenTimeSkew) {
            this.refreshTokenTimeSkew = Optional.of(refreshTokenTimeSkew);
        }

        public boolean isAllowJwtIntrospection() {
            return this.allowJwtIntrospection;
        }

        public void setAllowJwtIntrospection(boolean allowJwtIntrospection) {
            this.allowJwtIntrospection = allowJwtIntrospection;
        }

        public boolean isAllowOpaqueTokenIntrospection() {
            return this.allowOpaqueTokenIntrospection;
        }

        public void setAllowOpaqueTokenIntrospection(boolean allowOpaqueTokenIntrospection) {
            this.allowOpaqueTokenIntrospection = allowOpaqueTokenIntrospection;
        }

        public Optional<Duration> getAge() {
            return this.age;
        }

        public void setAge(Duration age) {
            this.age = Optional.of(age);
        }

        public Optional<String> getDecryptionKeyLocation() {
            return this.decryptionKeyLocation;
        }

        public void setDecryptionKeyLocation(String decryptionKeyLocation) {
            this.decryptionKeyLocation = Optional.of(decryptionKeyLocation);
        }

        public Map<String, String> getRequiredClaims() {
            return this.requiredClaims;
        }

        public void setRequiredClaims(Map<String, String> requiredClaims) {
            this.requiredClaims = requiredClaims;
        }

        public boolean isRequireJwtIntrospectionOnly() {
            return this.requireJwtIntrospectionOnly;
        }

        public void setRequireJwtIntrospectionOnly(boolean requireJwtIntrospectionOnly) {
            this.requireJwtIntrospectionOnly = requireJwtIntrospectionOnly;
        }
    }

    @ConfigGroup
    public static class CodeGrant {
        @ConfigItem
        public Map<String, String> extraParams = new HashMap<String, String>();
        @ConfigItem
        public Map<String, String> headers = new HashMap<String, String>();

        public Map<String, String> getExtraParams() {
            return this.extraParams;
        }

        public void setExtraParams(Map<String, String> extraParams) {
            this.extraParams = extraParams;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public void setHeaders(Map<String, String> headers) {
            this.headers = headers;
        }
    }

    @ConfigGroup
    public static class Authentication {
        @ConfigItem(defaultValueDocumentation="query")
        public Optional<ResponseMode> responseMode = Optional.empty();
        @ConfigItem
        public Optional<String> redirectPath = Optional.empty();
        @ConfigItem(defaultValue="false")
        public boolean restorePathAfterRedirect;
        @ConfigItem(defaultValue="true")
        public boolean removeRedirectParameters = true;
        @ConfigItem
        public Optional<String> errorPath = Optional.empty();
        @ConfigItem(defaultValue="false")
        public boolean verifyAccessToken;
        @ConfigItem(defaultValueDocumentation="false")
        public Optional<Boolean> forceRedirectHttpsScheme = Optional.empty();
        @ConfigItem
        public Optional<List<String>> scopes = Optional.empty();
        @ConfigItem(defaultValueDocumentation="true")
        public Optional<Boolean> addOpenidScope = Optional.empty();
        @ConfigItem
        public Map<String, String> extraParams;
        @ConfigItem(defaultValue="false")
        public boolean cookieForceSecure;
        @ConfigItem
        public Optional<String> cookieSuffix = Optional.empty();
        @ConfigItem(defaultValue="/")
        public String cookiePath = "/";
        @ConfigItem
        public Optional<String> cookiePathHeader = Optional.empty();
        @ConfigItem
        public Optional<String> cookieDomain = Optional.empty();
        @ConfigItem(defaultValueDocumentation="false")
        public Optional<Boolean> userInfoRequired = Optional.empty();
        @ConfigItem(defaultValue="5M")
        public Duration sessionAgeExtension = Duration.ofMinutes(5L);
        @ConfigItem(defaultValue="true")
        public boolean javaScriptAutoRedirect = true;
        @ConfigItem(defaultValueDocumentation="true")
        public Optional<Boolean> idTokenRequired = Optional.empty();
        @ConfigItem(defaultValueDocumentation="false")
        public Optional<Boolean> pkceRequired = Optional.empty();
        @ConfigItem
        public Optional<String> pkceSecret = Optional.empty();

        public Optional<Boolean> isPkceRequired() {
            return this.pkceRequired;
        }

        public void setPkceRequired(boolean pkceRequired) {
            this.pkceRequired = Optional.of(pkceRequired);
        }

        public Optional<String> getPkceSecret() {
            return this.pkceSecret;
        }

        public void setPkceSecret(String pkceSecret) {
            this.pkceSecret = Optional.of(pkceSecret);
        }

        public Optional<String> getErrorPath() {
            return this.errorPath;
        }

        public void setErrorPath(String errorPath) {
            this.errorPath = Optional.of(errorPath);
        }

        public boolean isJavaScriptAutoRedirect() {
            return this.javaScriptAutoRedirect;
        }

        public void setJavaScriptAutoredirect(boolean autoRedirect) {
            this.javaScriptAutoRedirect = autoRedirect;
        }

        public Optional<String> getRedirectPath() {
            return this.redirectPath;
        }

        public void setRedirectPath(String redirectPath) {
            this.redirectPath = Optional.of(redirectPath);
        }

        public Optional<List<String>> getScopes() {
            return this.scopes;
        }

        public void setScopes(List<String> scopes) {
            this.scopes = Optional.of(scopes);
        }

        public Map<String, String> getExtraParams() {
            return this.extraParams;
        }

        public void setExtraParams(Map<String, String> extraParams) {
            this.extraParams = extraParams;
        }

        public void setAddOpenidScope(boolean addOpenidScope) {
            this.addOpenidScope = Optional.of(addOpenidScope);
        }

        public Optional<Boolean> isAddOpenidScope() {
            return this.addOpenidScope;
        }

        public Optional<Boolean> isForceRedirectHttpsScheme() {
            return this.forceRedirectHttpsScheme;
        }

        public void setForceRedirectHttpsScheme(boolean forceRedirectHttpsScheme) {
            this.forceRedirectHttpsScheme = Optional.of(forceRedirectHttpsScheme);
        }

        public boolean isRestorePathAfterRedirect() {
            return this.restorePathAfterRedirect;
        }

        public void setRestorePathAfterRedirect(boolean restorePathAfterRedirect) {
            this.restorePathAfterRedirect = restorePathAfterRedirect;
        }

        public boolean isCookieForceSecure() {
            return this.cookieForceSecure;
        }

        public void setCookieForceSecure(boolean cookieForceSecure) {
            this.cookieForceSecure = cookieForceSecure;
        }

        public String getCookiePath() {
            return this.cookiePath;
        }

        public void setCookiePath(String cookiePath) {
            this.cookiePath = cookiePath;
        }

        public Optional<String> getCookieDomain() {
            return this.cookieDomain;
        }

        public void setCookieDomain(String cookieDomain) {
            this.cookieDomain = Optional.of(cookieDomain);
        }

        public Optional<Boolean> isUserInfoRequired() {
            return this.userInfoRequired;
        }

        public void setUserInfoRequired(boolean userInfoRequired) {
            this.userInfoRequired = Optional.of(userInfoRequired);
        }

        public boolean isRemoveRedirectParameters() {
            return this.removeRedirectParameters;
        }

        public void setRemoveRedirectParameters(boolean removeRedirectParameters) {
            this.removeRedirectParameters = removeRedirectParameters;
        }

        public boolean isVerifyAccessToken() {
            return this.verifyAccessToken;
        }

        public void setVerifyAccessToken(boolean verifyAccessToken) {
            this.verifyAccessToken = verifyAccessToken;
        }

        public Duration getSessionAgeExtension() {
            return this.sessionAgeExtension;
        }

        public void setSessionAgeExtension(Duration sessionAgeExtension) {
            this.sessionAgeExtension = sessionAgeExtension;
        }

        public Optional<String> getCookiePathHeader() {
            return this.cookiePathHeader;
        }

        public void setCookiePathHeader(String cookiePathHeader) {
            this.cookiePathHeader = Optional.of(cookiePathHeader);
        }

        public Optional<Boolean> isIdTokenRequired() {
            return this.idTokenRequired;
        }

        public void setIdTokenRequired(boolean idTokenRequired) {
            this.idTokenRequired = Optional.of(idTokenRequired);
        }

        public Optional<String> getCookieSuffix() {
            return this.cookieSuffix;
        }

        public void setCookieSuffix(String cookieSuffix) {
            this.cookieSuffix = Optional.of(cookieSuffix);
        }

        public Optional<ResponseMode> getResponseMode() {
            return this.responseMode;
        }

        public void setResponseMode(ResponseMode responseMode) {
            this.responseMode = Optional.of(responseMode);
        }

        public static enum ResponseMode {
            QUERY,
            FORM_POST;

        }
    }

    @ConfigGroup
    public static class Roles {
        @ConfigItem
        public Optional<List<String>> roleClaimPath = Optional.empty();
        @ConfigItem
        public Optional<String> roleClaimSeparator = Optional.empty();
        @ConfigItem
        public Optional<Source> source = Optional.empty();

        public static Roles fromClaimPath(List<String> path) {
            return Roles.fromClaimPathAndSeparator(path, null);
        }

        public static Roles fromClaimPathAndSeparator(List<String> path, String sep) {
            Roles roles = new Roles();
            roles.roleClaimPath = Optional.ofNullable(path);
            roles.roleClaimSeparator = Optional.ofNullable(sep);
            return roles;
        }

        public Optional<List<String>> getRoleClaimPath() {
            return this.roleClaimPath;
        }

        public void setRoleClaimPath(List<String> roleClaimPath) {
            this.roleClaimPath = Optional.of(roleClaimPath);
        }

        public Optional<String> getRoleClaimSeparator() {
            return this.roleClaimSeparator;
        }

        public void setRoleClaimSeparator(String roleClaimSeparator) {
            this.roleClaimSeparator = Optional.of(roleClaimSeparator);
        }

        public Optional<Source> getSource() {
            return this.source;
        }

        public void setSource(Source source) {
            this.source = Optional.of(source);
        }

        public static enum Source {
            idtoken,
            accesstoken,
            userinfo;

        }
    }

    @ConfigGroup
    public static class TokenStateManager {
        @ConfigItem(defaultValue="keep_all_tokens")
        public Strategy strategy = Strategy.KEEP_ALL_TOKENS;
        @ConfigItem(defaultValue="false")
        public boolean splitTokens;
        @ConfigItem(defaultValueDocumentation="false")
        public Optional<Boolean> encryptionRequired = Optional.empty();
        @ConfigItem
        public Optional<String> encryptionSecret = Optional.empty();

        public Optional<Boolean> isEncryptionRequired() {
            return this.encryptionRequired;
        }

        public void setEncryptionRequired(boolean encryptionRequired) {
            this.encryptionRequired = Optional.of(encryptionRequired);
        }

        public Optional<String> getEncryptionSecret() {
            return this.encryptionSecret;
        }

        public void setEncryptionSecret(String encryptionSecret) {
            this.encryptionSecret = Optional.of(encryptionSecret);
        }

        public boolean isSplitTokens() {
            return this.splitTokens;
        }

        public void setSplitTokens(boolean splitTokens) {
            this.splitTokens = splitTokens;
        }

        public Strategy getStrategy() {
            return this.strategy;
        }

        public void setStrategy(Strategy strategy) {
            this.strategy = strategy;
        }

        public static enum Strategy {
            KEEP_ALL_TOKENS,
            ID_TOKEN,
            ID_REFRESH_TOKENS;

        }
    }

    @ConfigGroup
    public static class Backchannel {
        @ConfigItem
        public Optional<String> path = Optional.empty();

        public void setPath(Optional<String> path) {
            this.path = path;
        }

        public String getPath() {
            return this.path.get();
        }
    }

    @ConfigGroup
    public static class Logout {
        @ConfigItem
        public Optional<String> path = Optional.empty();
        @ConfigItem
        public Optional<String> postLogoutPath = Optional.empty();
        @ConfigItem(defaultValue="post_logout_redirect_uri")
        public String postLogoutUriParam;
        @ConfigItem
        public Map<String, String> extraParams;
        @ConfigItem
        public Backchannel backchannel = new Backchannel();

        public void setPath(Optional<String> path) {
            this.path = path;
        }

        public String getPath() {
            return this.path.get();
        }

        public void setPostLogoutPath(Optional<String> postLogoutPath) {
            this.postLogoutPath = postLogoutPath;
        }

        public Optional<String> getPostLogoutPath() {
            return this.postLogoutPath;
        }

        public Map<String, String> getExtraParams() {
            return this.extraParams;
        }

        public void setExtraParams(Map<String, String> extraParams) {
            this.extraParams = extraParams;
        }

        public String getPostLogoutUriParam() {
            return this.postLogoutUriParam;
        }

        public void setPostLogoutUriParam(String postLogoutUriParam) {
            this.postLogoutUriParam = postLogoutUriParam;
        }

        public Backchannel getBackchannel() {
            return this.backchannel;
        }

        public void setBackchannel(Backchannel backchannel) {
            this.backchannel = backchannel;
        }
    }

    @ConfigGroup
    public static class IntrospectionCredentials {
        @ConfigItem
        public Optional<String> name = Optional.empty();
        @ConfigItem
        public Optional<String> secret = Optional.empty();
        @ConfigItem(defaultValue="true")
        public boolean includeClientId = true;

        public Optional<String> getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = Optional.of(name);
        }

        public Optional<String> getSecret() {
            return this.secret;
        }

        public void setSecret(String secret) {
            this.secret = Optional.of(secret);
        }

        public boolean isIncludeClientId() {
            return this.includeClientId;
        }

        public void setIncludeClientId(boolean includeClientId) {
            this.includeClientId = includeClientId;
        }
    }
}

